/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DaoUtils;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.WildcardPosition;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.GroupMapper;

public class GroupDao
implements Dao {
    private final System2 system;

    public GroupDao(System2 system) {
        this.system = system;
    }

    public Optional<GroupDto> selectByName(DbSession dbSession, String organizationUuid, String name) {
        return Optional.ofNullable(GroupDao.mapper(dbSession).selectByName(organizationUuid, name));
    }

    public List<GroupDto> selectByNames(DbSession dbSession, String organizationUuid, Collection<String> names) {
        return DatabaseUtils.executeLargeInputs(names, pageOfNames -> GroupDao.mapper(dbSession).selectByNames(organizationUuid, (List<String>)pageOfNames));
    }

    @CheckForNull
    public GroupDto selectById(DbSession dbSession, int groupId) {
        return GroupDao.mapper(dbSession).selectById(groupId);
    }

    public List<GroupDto> selectByIds(DbSession dbSession, List<Integer> ids) {
        return DatabaseUtils.executeLargeInputs(ids, GroupDao.mapper(dbSession)::selectByIds);
    }

    public void deleteById(DbSession dbSession, int groupId) {
        GroupDao.mapper(dbSession).deleteById(groupId);
    }

    public void deleteByOrganization(DbSession dbSession, String organizationUuid) {
        GroupDao.mapper(dbSession).deleteByOrganization(organizationUuid);
    }

    public int countByQuery(DbSession session, String organizationUuid, @Nullable String query) {
        return GroupDao.mapper(session).countByQuery(organizationUuid, GroupDao.groupSearchToSql(query));
    }

    public List<GroupDto> selectByQuery(DbSession session, String organizationUuid, @Nullable String query, int offset, int limit) {
        return GroupDao.mapper(session).selectByQuery(organizationUuid, GroupDao.groupSearchToSql(query), new RowBounds(offset, limit));
    }

    public GroupDto insert(DbSession session, GroupDto item) {
        Date createdAt = new Date(this.system.now());
        item.setCreatedAt(createdAt).setUpdatedAt(createdAt);
        GroupDao.mapper(session).insert(item);
        return item;
    }

    public GroupDto update(DbSession session, GroupDto item) {
        item.setUpdatedAt(new Date(this.system.now()));
        GroupDao.mapper(session).update(item);
        return item;
    }

    public List<GroupDto> selectByUserLogin(DbSession session, String login) {
        return GroupDao.mapper(session).selectByUserLogin(login);
    }

    @CheckForNull
    private static String groupSearchToSql(@Nullable String query) {
        if (query == null) {
            return null;
        }
        String upperCasedNameQuery = StringUtils.upperCase((String)query, (Locale)Locale.ENGLISH);
        return DaoUtils.buildLikeValue(upperCasedNameQuery, WildcardPosition.BEFORE_AND_AFTER);
    }

    public List<GroupDto> selectByOrganizationUuid(DbSession dbSession, String organizationUuid) {
        return GroupDao.mapper(dbSession).selectByOrganizationUuid(organizationUuid);
    }

    private static GroupMapper mapper(DbSession session) {
        return (GroupMapper)session.getMapper(GroupMapper.class);
    }
}

