/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.user.RoleMapper;

public class RoleDao
implements Dao {
    private static final Set<String> UNSUPPORTED_PROJECT_PERMISSIONS = ImmutableSet.of((Object)"user", (Object)"codeviewer");

    public List<Long> selectComponentIdsByPermissionAndUserId(DbSession dbSession, String permission, int userId) {
        Preconditions.checkArgument((!UNSUPPORTED_PROJECT_PERMISSIONS.contains(permission) ? 1 : 0) != 0, (String)"Permissions %s are not supported by selectComponentIdsByPermissionAndUserId", (Object[])new Object[]{UNSUPPORTED_PROJECT_PERMISSIONS});
        return RoleDao.mapper(dbSession).selectComponentIdsByPermissionAndUserId(permission, userId);
    }

    public void deleteGroupRolesByGroupId(DbSession session, int groupId) {
        RoleDao.mapper(session).deleteGroupRolesByGroupId(groupId);
    }

    private static RoleMapper mapper(DbSession session) {
        return (RoleMapper)session.getMapper(RoleMapper.class);
    }
}

