/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.db.migration.charset.CharsetHandler;
import org.sonar.server.platform.db.migration.charset.ColumnDef;
import org.sonar.server.platform.db.migration.charset.DatabaseCharsetChecker;
import org.sonar.server.platform.db.migration.charset.MssqlMetadataReader;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

class MssqlCharsetHandler
extends CharsetHandler {
    private static final Logger LOGGER = Loggers.get(MssqlCharsetHandler.class);
    private static final String CASE_SENSITIVE_ACCENT_SENSITIVE = "_CS_AS";
    private static final String CASE_INSENSITIVE_ACCENT_INSENSITIVE = "_CI_AI";
    private static final String CASE_INSENSITIVE_ACCENT_SENSITIVE = "_CI_AS";
    private static final String CASE_SENSITIVE_ACCENT_INSENSITIVE = "_CS_AI";
    private static final String BIN = "BIN";
    private static final String BIN2 = "BIN2";
    private final MssqlMetadataReader metadata;

    MssqlCharsetHandler(SqlExecutor selectExecutor, MssqlMetadataReader metadataReader) {
        super(selectExecutor);
        this.metadata = metadataReader;
    }

    @Override
    void handle(Connection connection, DatabaseCharsetChecker.State state) throws SQLException {
        this.expectCaseSensitiveDefaultCollation(connection);
        if (state == DatabaseCharsetChecker.State.UPGRADE || state == DatabaseCharsetChecker.State.STARTUP) {
            this.repairColumns(connection);
        }
    }

    private void expectCaseSensitiveDefaultCollation(Connection connection) throws SQLException {
        LOGGER.info("Verify that database collation is case-sensitive and accent-sensitive");
        String defaultCollation = this.metadata.getDefaultCollation(connection);
        if (!MssqlCharsetHandler.isCollationCorrect(defaultCollation)) {
            String fixedCollation = MssqlCharsetHandler.toCaseSensitive(defaultCollation);
            throw MessageException.of((String)String.format("Database collation must be case-sensitive and accent-sensitive. It is %s but should be %s.", defaultCollation, fixedCollation));
        }
    }

    private void repairColumns(Connection connection) throws SQLException {
        String defaultCollation = this.metadata.getDefaultCollation(connection);
        List<ColumnDef> columns = this.metadata.getColumnDefs(connection);
        for (ColumnDef column : columns.stream().filter(ColumnDef::isInSonarQubeTable).collect(Collectors.toList())) {
            String collation = column.getCollation();
            if (!MssqlCharsetHandler.isCollationCorrect(collation)) {
                this.repairColumnCollation(connection, column, MssqlCharsetHandler.toCaseSensitive(collation));
                continue;
            }
            if (!"Latin1_General_CS_AS".equals(collation) || collation.equals(defaultCollation)) continue;
            this.repairColumnCollation(connection, column, defaultCollation);
        }
    }

    private static boolean isCollationCorrect(String collation) {
        return StringUtils.containsIgnoreCase((String)collation, (String)CASE_SENSITIVE_ACCENT_SENSITIVE) || StringUtils.containsIgnoreCase((String)collation, (String)BIN) || StringUtils.containsIgnoreCase((String)collation, (String)BIN2);
    }

    private void repairColumnCollation(Connection connection, ColumnDef column, String expectedCollation) throws SQLException {
        List<ColumnIndex> indices = this.metadata.getColumnIndices(connection, column);
        for (ColumnIndex index : indices) {
            this.getSqlExecutor().executeDdl(connection, String.format("DROP INDEX %s.%s", column.getTable(), index.name));
        }
        String nullability = column.isNullable() ? "NULL" : "NOT NULL";
        String size = column.getSize() >= 0L ? String.valueOf(column.getSize()) : "max";
        String alterSql = String.format("ALTER TABLE %s ALTER COLUMN %s %s(%s) COLLATE %s %s", column.getTable(), column.getColumn(), column.getDataType(), size, expectedCollation, nullability);
        LOGGER.info("Changing collation of column [{}.{}] from {} to {} | sql=", new Object[]{column.getTable(), column.getColumn(), column.getCollation(), expectedCollation, alterSql});
        this.getSqlExecutor().executeDdl(connection, alterSql);
        for (ColumnIndex index : indices) {
            String uniqueSql = index.unique ? "UNIQUE" : "";
            String createIndexSql = String.format("CREATE %s INDEX %s ON %s (%s)", uniqueSql, index.name, column.getTable(), index.csvColumns);
            this.getSqlExecutor().executeDdl(connection, createIndexSql);
        }
    }

    @VisibleForTesting
    static String toCaseSensitive(String collation) {
        return collation.replace(CASE_INSENSITIVE_ACCENT_INSENSITIVE, CASE_SENSITIVE_ACCENT_SENSITIVE).replace(CASE_INSENSITIVE_ACCENT_SENSITIVE, CASE_SENSITIVE_ACCENT_SENSITIVE).replace(CASE_SENSITIVE_ACCENT_INSENSITIVE, CASE_SENSITIVE_ACCENT_SENSITIVE);
    }

    @VisibleForTesting
    static enum ColumnIndexConverter implements SqlExecutor.RowConverter<ColumnIndex>
    {
        INSTANCE;


        @Override
        public ColumnIndex convert(ResultSet rs) throws SQLException {
            return new ColumnIndex(rs.getString(1), rs.getBoolean(2), rs.getString(3));
        }
    }

    @VisibleForTesting
    static class ColumnIndex {
        private final String name;
        private final boolean unique;
        private final String csvColumns;

        public ColumnIndex(String name, boolean unique, String csvColumns) {
            this.name = name;
            this.unique = unique;
            this.csvColumns = csvColumns;
        }
    }
}

