/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class BlobColumnDef
extends AbstractColumnDef {
    public BlobColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, null);
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "mssql": {
                return "VARBINARY(MAX)";
            }
            case "mysql": {
                return "LONGBLOB";
            }
            case "oracle": 
            case "h2": {
                return "BLOB";
            }
            case "postgresql": {
                return "BYTEA";
            }
        }
        throw new IllegalArgumentException("Unsupported dialect id " + dialect.getId());
    }

    public static Builder newBlobColumnDefBuilder() {
        return new Builder();
    }

    public static class Builder {
        @CheckForNull
        private String columnName;
        private boolean isNullable = true;

        private Builder() {
        }

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public BlobColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new BlobColumnDef(this);
        }
    }
}

