/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class ClobColumnDef
extends AbstractColumnDef {
    private ClobColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, null);
    }

    public static Builder newClobColumnDefBuilder() {
        return new Builder();
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "mssql": {
                return "NVARCHAR (MAX)";
            }
            case "mysql": {
                return "LONGTEXT";
            }
            case "oracle": {
                return "CLOB";
            }
            case "h2": {
                return "CLOB(2147483647)";
            }
            case "postgresql": {
                return "TEXT";
            }
        }
        throw new IllegalArgumentException("Unsupported dialect id " + dialect.getId());
    }

    public static class Builder {
        private String columnName;
        private boolean isNullable = true;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public ClobColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new ClobColumnDef(this);
        }
    }
}

