/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.ColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

public class AlterColumnsBuilder {
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String ALTER_COLUMN = "ALTER COLUMN ";
    private final Dialect dialect;
    private final String tableName;
    private final List<ColumnDef> columnDefs = Lists.newArrayList();

    public AlterColumnsBuilder(Dialect dialect, String tableName) {
        this.dialect = dialect;
        this.tableName = Validations.validateTableName(tableName);
    }

    public AlterColumnsBuilder updateColumn(ColumnDef columnDef) {
        Preconditions.checkArgument((columnDef.getDefaultValue() == null ? 1 : 0) != 0, (String)"Default value is not supported on alter of column '%s'", (Object[])new Object[]{columnDef.getName()});
        this.columnDefs.add(columnDef);
        return this;
    }

    public List<String> build() {
        if (this.columnDefs.isEmpty()) {
            throw new IllegalStateException("No column has been defined");
        }
        switch (this.dialect.getId()) {
            case "postgresql": {
                return this.createPostgresQuery();
            }
            case "mysql": {
                return this.createMySqlQuery();
            }
            case "oracle": {
                return this.createOracleQuery();
            }
        }
        return this.createMsSqlAndH2Queries();
    }

    private List<String> createPostgresQuery() {
        StringBuilder sql = new StringBuilder(ALTER_TABLE + this.tableName + " ");
        Iterator<ColumnDef> columnDefIterator = this.columnDefs.iterator();
        while (columnDefIterator.hasNext()) {
            ColumnDef columnDef = columnDefIterator.next();
            sql.append(ALTER_COLUMN);
            this.addColumn(sql, columnDef, "TYPE ", false);
            sql.append(", ");
            sql.append(ALTER_COLUMN);
            sql.append(columnDef.getName());
            sql.append(' ').append(columnDef.isNullable() ? "DROP" : "SET").append(" NOT NULL");
            if (!columnDefIterator.hasNext()) continue;
            sql.append(", ");
        }
        return Collections.singletonList(sql.toString());
    }

    private List<String> createMySqlQuery() {
        StringBuilder sql = new StringBuilder(ALTER_TABLE + this.tableName + " ");
        this.addColumns(sql, "MODIFY COLUMN ", "", true);
        return Collections.singletonList(sql.toString());
    }

    private List<String> createOracleQuery() {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnDef columnDef : this.columnDefs) {
            StringBuilder sql = new StringBuilder(ALTER_TABLE + this.tableName + " ").append("MODIFY (");
            this.addColumn(sql, columnDef, "", true);
            sql.append(")");
            sqls.add(sql.toString());
        }
        return sqls;
    }

    private List<String> createMsSqlAndH2Queries() {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnDef columnDef : this.columnDefs) {
            StringBuilder defaultQuery = new StringBuilder(ALTER_TABLE + this.tableName + " ");
            defaultQuery.append(ALTER_COLUMN);
            this.addColumn(defaultQuery, columnDef, "", true);
            sqls.add(defaultQuery.toString());
        }
        return sqls;
    }

    private void addColumns(StringBuilder sql, String updateKeyword, String typePrefix, boolean addNotNullableProperty) {
        Iterator<ColumnDef> columnDefIterator = this.columnDefs.iterator();
        while (columnDefIterator.hasNext()) {
            sql.append(updateKeyword);
            this.addColumn(sql, columnDefIterator.next(), typePrefix, addNotNullableProperty);
            if (!columnDefIterator.hasNext()) continue;
            sql.append(", ");
        }
    }

    private void addColumn(StringBuilder sql, ColumnDef columnDef, String typePrefix, boolean addNotNullableProperty) {
        sql.append(columnDef.getName()).append(" ").append(typePrefix).append(columnDef.generateSqlType(this.dialect));
        if (addNotNullableProperty) {
            sql.append(columnDef.isNullable() ? " NULL" : " NOT NULL");
        }
    }
}

