/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.ColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;

public class CreateIndexBuilder {
    private static final int MAX_LENGTH_ON_MYSQL = 255;
    private final Dialect dialect;
    private final List<ColumnDef> columns = new ArrayList<ColumnDef>();
    private String tableName;
    private String indexName;
    private boolean unique = false;

    public CreateIndexBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public CreateIndexBuilder setTable(String s) {
        this.tableName = s;
        return this;
    }

    public CreateIndexBuilder setName(String s) {
        this.indexName = s;
        return this;
    }

    public CreateIndexBuilder setUnique(boolean b) {
        this.unique = b;
        return this;
    }

    public CreateIndexBuilder addColumn(ColumnDef column) {
        this.columns.add(Objects.requireNonNull(column, "Column cannot be null"));
        return this;
    }

    public List<String> build() {
        Validations.validateTableName(this.tableName);
        Validations.validateIndexName(this.indexName);
        Preconditions.checkArgument((!this.columns.isEmpty() ? 1 : 0) != 0, (Object)"at least one column must be specified");
        return Collections.singletonList(this.createSqlStatement());
    }

    private String createSqlStatement() {
        StringBuilder sql = new StringBuilder("CREATE ");
        if (this.unique) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        sql.append(this.indexName);
        sql.append(" ON ");
        sql.append(this.tableName);
        sql.append(" (");
        sql.append(this.columns.stream().map(this::columnSql).collect(Collectors.joining(", ")));
        sql.append(")");
        return sql.toString();
    }

    private String columnSql(ColumnDef column) {
        VarcharColumnDef varcharColumn;
        String length = "";
        if (this.dialect.getId().equals("mysql") && column instanceof VarcharColumnDef && (varcharColumn = (VarcharColumnDef)column).getColumnSize() > 255) {
            length = "(255)";
        }
        return column.getName() + length;
    }
}

