/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.Validations;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;

public class RenameTableBuilder {
    private final Dialect dialect;
    private String name;
    private String newName;
    private boolean autoGeneratedId = true;

    public RenameTableBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public RenameTableBuilder setName(String s) {
        this.name = s;
        return this;
    }

    public RenameTableBuilder setNewName(String s) {
        this.newName = s;
        return this;
    }

    public RenameTableBuilder setAutoGeneratedId(boolean autoGeneratedId) {
        this.autoGeneratedId = autoGeneratedId;
        return this;
    }

    public List<String> build() {
        Validations.validateTableName(this.name);
        Validations.validateTableName(this.newName);
        Preconditions.checkArgument((!this.name.equals(this.newName) ? 1 : 0) != 0, (Object)"Names must be different");
        return this.createSqlStatement();
    }

    private List<String> createSqlStatement() {
        switch (this.dialect.getId()) {
            case "h2": 
            case "mysql": 
            case "postgresql": {
                return Collections.singletonList("ALTER TABLE " + this.name + " RENAME TO " + this.newName);
            }
            case "mssql": {
                return Collections.singletonList("EXEC sp_rename '" + this.name + "', '" + this.newName + "'");
            }
            case "oracle": {
                String renameSqlCommand = "RENAME " + this.name + " TO " + this.newName;
                return this.autoGeneratedId ? Arrays.asList("DROP TRIGGER " + this.name + "_idt", renameSqlCommand, "RENAME " + this.name + "_seq TO " + this.newName + "_seq", CreateTableBuilder.createOracleTriggerForTable(this.newName)) : Collections.singletonList(renameSqlCommand);
            }
        }
        throw new IllegalArgumentException("Unsupported dialect id " + this.dialect.getId());
    }
}

