/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.server.platform.db.migration.engine.MigrationContainer;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.step.MigrationStep;
import org.sonar.server.platform.db.migration.step.MigrationStepExecutionException;
import org.sonar.server.platform.db.migration.step.MigrationStepsExecutor;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

public class MigrationStepsExecutorImpl
implements MigrationStepsExecutor {
    private static final Logger LOGGER = Loggers.get((String)"DbMigrations");
    private static final String GLOBAL_START_MESSAGE = "Executing DB migrations...";
    private static final String GLOBAL_END_MESSAGE = "Executed DB migrations: {}";
    private static final String STEP_START_PATTERN = "{}...";
    private static final String STEP_STOP_PATTERN = "{}: {}";
    private final MigrationContainer migrationContainer;
    private final MigrationHistory migrationHistory;

    public MigrationStepsExecutorImpl(MigrationContainer migrationContainer, MigrationHistory migrationHistory) {
        this.migrationContainer = migrationContainer;
        this.migrationHistory = migrationHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<RegisteredMigrationStep> steps) {
        block5: {
            Profiler globalProfiler;
            block4: {
                globalProfiler = Profiler.create((Logger)LOGGER);
                globalProfiler.startInfo(GLOBAL_START_MESSAGE);
                boolean allStepsExecuted = false;
                try {
                    steps.forEach(this::execute);
                    allStepsExecuted = true;
                    if (!allStepsExecuted) break block4;
                }
                catch (Throwable throwable) {
                    if (allStepsExecuted) {
                        globalProfiler.stopInfo(GLOBAL_END_MESSAGE, new Object[]{"success"});
                    } else {
                        globalProfiler.stopError(GLOBAL_END_MESSAGE, new Object[]{"failure"});
                    }
                    throw throwable;
                }
                globalProfiler.stopInfo(GLOBAL_END_MESSAGE, new Object[]{"success"});
                break block5;
            }
            globalProfiler.stopError(GLOBAL_END_MESSAGE, new Object[]{"failure"});
        }
    }

    private void execute(RegisteredMigrationStep step) {
        MigrationStep migrationStep = (MigrationStep)this.migrationContainer.getComponentByType(step.getStepClass());
        Preconditions.checkState((migrationStep != null ? 1 : 0) != 0, (Object)("Can not find instance of " + step.getStepClass()));
        this.execute(step, migrationStep);
    }

    private void execute(RegisteredMigrationStep step, MigrationStep migrationStep) {
        block7: {
            Profiler stepProfiler;
            block6: {
                stepProfiler = Profiler.create((Logger)LOGGER);
                stepProfiler.startInfo(STEP_START_PATTERN, new Object[]{step});
                boolean done = false;
                try {
                    migrationStep.execute();
                    this.migrationHistory.done(step);
                    done = true;
                    if (!done) break block6;
                }
                catch (Exception e) {
                    try {
                        throw new MigrationStepExecutionException(step, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (done) {
                            stepProfiler.stopInfo(STEP_STOP_PATTERN, new Object[]{step, "success"});
                        } else {
                            stepProfiler.stopError(STEP_STOP_PATTERN, new Object[]{step, "failure"});
                        }
                        throw throwable;
                    }
                }
                stepProfiler.stopInfo(STEP_STOP_PATTERN, new Object[]{step, "success"});
                break block7;
            }
            stepProfiler.stopError(STEP_STOP_PATTERN, new Object[]{step, "failure"});
        }
    }
}

