/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanOrphanRowsInSnapshots
extends DataChange {
    public CleanOrphanRowsInSnapshots(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT sn.id, sn.project_id, sn.root_project_id from snapshots sn where sn.component_uuid is null or sn.root_component_uuid is null");
        massUpdate.update("DELETE from duplications_index WHERE snapshot_id=? or project_snapshot_id=?");
        massUpdate.update("DELETE from project_measures WHERE snapshot_id=?");
        massUpdate.update("DELETE from ce_activity WHERE snapshot_id=?");
        massUpdate.update("DELETE from events WHERE snapshot_id=?");
        massUpdate.update("DELETE from snapshots WHERE id=?");
        massUpdate.rowPluralName("snapshots");
        massUpdate.execute((Select.Row row, SqlStatement update, int updateIndex) -> {
            long snapshotId = row.getLong(1);
            switch (updateIndex) {
                case 0: {
                    update.setLong(1, snapshotId);
                    update.setLong(2, snapshotId);
                    return true;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    update.setLong(1, snapshotId);
                    return true;
                }
            }
            throw new IllegalArgumentException("Unsupported update index " + updateIndex);
        });
    }
}

