/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.AlterColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class MakeComponentUuidColumnsNotNullOnSnapshots
extends DdlChange {
    private static final String TABLE_SNAPSHOTS = "snapshots";

    public MakeComponentUuidColumnsNotNullOnSnapshots(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        VarcharColumnDef componentUuid = MakeComponentUuidColumnsNotNullOnSnapshots.newUuidColumn("component_uuid");
        VarcharColumnDef rootComponentUuid = MakeComponentUuidColumnsNotNullOnSnapshots.newUuidColumn("root_component_uuid");
        context.execute(new AlterColumnsBuilder(this.getDatabase().getDialect(), TABLE_SNAPSHOTS).updateColumn(componentUuid).updateColumn(rootComponentUuid).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_SNAPSHOTS).setName("snapshot_component").addColumn(componentUuid).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_SNAPSHOTS).setName("snapshot_root_component").addColumn(rootComponentUuid).build());
    }

    private static VarcharColumnDef newUuidColumn(String columnName) {
        return VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName(columnName).setLimit(50).setIsNullable(false).setIgnoreOracleUnit(true).build();
    }
}

