/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateComponentUuidColumnsOfSnapshots
extends DataChange {
    public PopulateComponentUuidColumnsOfSnapshots(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Map<Long, String> componentUuidById = PopulateComponentUuidColumnsOfSnapshots.buildComponentUuidMap(context);
        if (componentUuidById.isEmpty()) {
            return;
        }
        PopulateComponentUuidColumnsOfSnapshots.populateUuidColumns(context, componentUuidById);
    }

    private static Map<Long, String> buildComponentUuidMap(DataChange.Context context) throws SQLException {
        HashMap<Long, String> componentUuidById = new HashMap<Long, String>();
        context.prepareSelect("select distinct p.id, p.uuid from projects p join snapshots sn1 on sn1.project_id = p.id and sn1.component_uuid is null").scroll(row -> componentUuidById.put(row.getLong(1), row.getString(2)));
        context.prepareSelect("select distinct p.id, p.uuid from projects p join snapshots sn2 on sn2.root_project_id = p.id and sn2.root_component_uuid is null").scroll(row -> componentUuidById.put(row.getLong(1), row.getString(2)));
        return componentUuidById;
    }

    private static void populateUuidColumns(DataChange.Context context, Map<Long, String> componentUuidById) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT sn.id, sn.project_id, sn.root_project_id from snapshots sn where sn.component_uuid is null or sn.root_component_uuid is null");
        massUpdate.update("UPDATE snapshots SET component_uuid=?, root_component_uuid=? WHERE id=?");
        massUpdate.rowPluralName("snapshots");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateComponentUuidColumnsOfSnapshots.handle(componentUuidById, row, update));
    }

    private static boolean handle(Map<Long, String> componentUuidById, Select.Row row, SqlStatement update) throws SQLException {
        long id = row.getLong(1);
        long componentId = row.getLong(2);
        long rootProjectId = row.getLong(3);
        String componentUuid = componentUuidById.get(componentId);
        String rootComponentUuid = componentUuidById.get(rootProjectId);
        if (componentUuid == null && rootComponentUuid == null) {
            return false;
        }
        update.setString(1, componentUuid);
        update.setString(2, rootComponentUuid);
        update.setLong(3, id);
        return true;
    }
}

