/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v62;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateOrganizationUuidOfGroups
extends DataChange {
    private static final String INTERNAL_PROPERTY_DEFAULT_ORGANIZATION = "organization.default";
    private final System2 system2;

    public PopulateOrganizationUuidOfGroups(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        String organizationUuid = PopulateOrganizationUuidOfGroups.selectDefaultOrganizationUuid(context);
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id from groups where organization_uuid is null");
        massUpdate.update("update groups set organization_uuid=?, updated_at=? where id=?");
        massUpdate.rowPluralName("groups");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            int groupId = row.getInt(1);
            update.setString(1, organizationUuid);
            update.setDate(2, new Date(this.system2.now()));
            update.setInt(3, groupId);
            return true;
        });
    }

    private static String selectDefaultOrganizationUuid(DataChange.Context context) throws SQLException {
        Select select = context.prepareSelect("select text_value from internal_properties where kee=?");
        select.setString(1, INTERNAL_PROPERTY_DEFAULT_ORGANIZATION);
        String uuid = select.get(row -> row.getString(1));
        Preconditions.checkState((uuid != null ? 1 : 0) != 0, (Object)"Default organization uuid is missing");
        return uuid;
    }
}

