/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v64;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

public class UpgradeQualityTemplateLoadedTemplates
extends DataChange {
    private static final String QUALITY_PROFILE_TYPE = "QUALITY_PROFILE";
    private final DefaultOrganizationUuidProvider defaultOrganizationUuid;

    public UpgradeQualityTemplateLoadedTemplates(Database db, DefaultOrganizationUuidProvider defaultOrganizationUuid) {
        super(db);
        this.defaultOrganizationUuid = defaultOrganizationUuid;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        String defaultOrganizationUuid = this.defaultOrganizationUuid.getAndCheck(context);
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id,kee from loaded_templates where template_type=?").setString(1, QUALITY_PROFILE_TYPE);
        massUpdate.rowPluralName("loaded templates for quality profiles");
        massUpdate.update("update loaded_templates set template_type=?,kee=? where id=?");
        MessageDigest md5Digest = DigestUtils.getMd5Digest();
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            int id = row.getInt(1);
            String key = row.getString(2);
            update.setString(1, UpgradeQualityTemplateLoadedTemplates.computeLoadedTemplateType(key, md5Digest));
            update.setString(2, defaultOrganizationUuid);
            update.setInt(3, id);
            return true;
        });
    }

    private static String computeLoadedTemplateType(String currentKey, MessageDigest messageDigest) {
        return String.format("%s.%s", QUALITY_PROFILE_TYPE, Hex.encodeHexString((byte[])messageDigest.digest(currentKey.getBytes(StandardCharsets.UTF_8))));
    }
}

