/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class EnsureIssueProjectUuidConsistencyOnIssues
extends DataChange {
    public EnsureIssueProjectUuidConsistencyOnIssues(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select i.id, p.project_uuid from issues i inner join projects p on   p.uuid = i.component_uuid   and i.project_uuid <> p.project_uuid");
        massUpdate.update("update issues set project_uuid = ? where id = ?");
        massUpdate.rowPluralName("issues with inconsistent project_uuid");
        massUpdate.execute(EnsureIssueProjectUuidConsistencyOnIssues::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long issueId = row.getLong(1);
        String projectUuid = row.getString(2);
        update.setString(1, projectUuid);
        update.setLong(2, issueId);
        return true;
    }
}

