/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class AssociateQualityGatesToDefaultOrganization
extends DataChange {
    private final UuidFactory uuidFactory;

    public AssociateQualityGatesToDefaultOrganization(Database db, UuidFactory uuidFactory) {
        super(db);
        this.uuidFactory = uuidFactory;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        String defaultOrgUuid = context.prepareSelect("select text_value from internal_properties where kee = 'organization.default'").get(row -> row.getString(1));
        Preconditions.checkState((defaultOrgUuid != null ? 1 : 0) != 0, (Object)"Default organization uuid is missing");
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT qg.uuid from quality_gates qg  WHERE qg.is_built_in = ?  AND NOT EXISTS (SELECT 1 FROM org_quality_gates oqg WHERE oqg.quality_gate_uuid = qg.uuid AND oqg.organization_uuid = ?)").setBoolean(1, false).setString(2, defaultOrgUuid);
        massUpdate.rowPluralName("quality gates");
        massUpdate.update("insert into org_quality_gates (uuid, quality_gate_uuid, organization_uuid) values(?, ?, ?)");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, this.uuidFactory.create());
            update.setString(2, row.getString(1));
            update.setString(3, defaultOrgUuid);
            return true;
        });
    }
}

