/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.List;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateOrgQualityGates
extends DataChange {
    private final UuidFactory uuidFactory;

    public PopulateOrgQualityGates(Database db, UuidFactory uuidFactory) {
        super(db);
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Long nbOfOrganizations = context.prepareSelect("select count(uuid) from organizations").get(row -> row.getLong(1));
        if (nbOfOrganizations == 0L) {
            return;
        }
        List<String> builtInQGUuids = ((Select)context.prepareSelect("select uuid from quality_gates where is_built_in = ?").setBoolean(1, true)).list(row -> row.getString(1));
        Preconditions.checkState((!builtInQGUuids.isEmpty() ? 1 : 0) != 0, (Object)"Unable to find the builtin quality gate");
        Preconditions.checkState((builtInQGUuids.size() == 1 ? 1 : 0) != 0, (Object)"There are too many built in quality gates, one and only one is expected");
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid from organizations o  where   not exists (select 1 from org_quality_gates oqg where oqg.quality_gate_uuid = ? and oqg.organization_uuid = o.uuid)").setString(1, builtInQGUuids.get(0));
        massUpdate.rowPluralName("organizations");
        massUpdate.update("insert into org_quality_gates (uuid, quality_gate_uuid, organization_uuid) values(?, ?, ?)");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, this.uuidFactory.create());
            update.setString(2, (String)builtInQGUuids.get(0));
            update.setString(3, row.getString(1));
            return true;
        });
    }
}

