/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateQualityGatesIsBuiltIn
extends DataChange {
    private static final String SONARQUBE_WAY_QUALITY_GATE = "SonarQube way";
    private final System2 system2;

    public PopulateQualityGatesIsBuiltIn(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id, name from quality_gates where is_built_in is null");
        massUpdate.rowPluralName("quality_gates");
        massUpdate.update("update quality_gates set is_built_in=?, updated_at=? where id=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String name = row.getString(2);
            update.setBoolean(1, SONARQUBE_WAY_QUALITY_GATE.equals(name));
            update.setDate(2, new Date(this.system2.now()));
            update.setLong(3, row.getLong(1));
            return true;
        });
    }
}

