/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanCeChildTablesOrphans
extends DataChange {
    public CleanCeChildTablesOrphans(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        CleanCeChildTablesOrphans.deleteOrphansInCeChildTable(context, "ce_task_input");
        CleanCeChildTablesOrphans.deleteOrphansInCeChildTable(context, "ce_scanner_context");
        CleanCeChildTablesOrphans.deleteOrphansInCeChildTable(context, "ce_task_characteristics");
    }

    private static void deleteOrphansInCeChildTable(DataChange.Context context, String childTableName) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select task_uuid from " + childTableName + " child where not exists (select 1 from ce_activity a where a.uuid = child.task_uuid) and not exists (select 1 from ce_queue q where q.uuid = child.task_uuid)");
        massUpdate.rowPluralName("orphans rows in " + childTableName);
        massUpdate.update("delete from " + childTableName + " where task_uuid=?");
        massUpdate.execute(CleanCeChildTablesOrphans::deleteByTaskUuid);
    }

    private static boolean deleteByTaskUuid(Select.Row row, SqlStatement update) throws SQLException {
        String taskUuid = row.getString(1);
        update.setString(1, taskUuid);
        return true;
    }
}

