/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class CreateWebhooksTable
extends DdlChange {
    private static final String TABLE_NAME = "webhooks";
    private static final String ORGANIZATION_WEBHOOK_INDEX_NAME = "organization_webhook";
    private static final String PROJECT_WEBHOOK_INDEX_NAME = "project_webhook";
    private static final VarcharColumnDef UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef NAME_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("name").setIsNullable(false).setLimit(100).build();
    private static final VarcharColumnDef URL_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("url").setIsNullable(false).setLimit(2000).build();
    private static final VarcharColumnDef ORGANIZATION_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("organization_uuid").setIsNullable(true).setLimit(40).build();
    private static final VarcharColumnDef PROJECT_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("project_uuid").setIsNullable(true).setLimit(40).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();
    private static final BigIntegerColumnDef UPDATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build();

    public CreateWebhooksTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID_COLUMN, new CreateTableBuilder.ColumnFlag[0]).addColumn(NAME_COLUMN).addColumn(URL_COLUMN).addColumn(ORGANIZATION_UUID_COLUMN).addColumn(PROJECT_UUID_COLUMN).addColumn(CREATED_AT_COLUMN).addColumn(UPDATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ORGANIZATION_UUID_COLUMN).setUnique(false).setTable(TABLE_NAME).setName(ORGANIZATION_WEBHOOK_INDEX_NAME).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(PROJECT_UUID_COLUMN).setUnique(false).setTable(TABLE_NAME).setName(PROJECT_WEBHOOK_INDEX_NAME).build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

