/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class SetKeyTypeToBranchInProjectBranches
extends DataChange {
    static final String TABLE_NAME = "project_branches";
    static final String DEFAULT_KEY_TYPE = "BRANCH";
    private final System2 system2;

    public SetKeyTypeToBranchInProjectBranches(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.rowPluralName("branches");
        massUpdate.select("select uuid from project_branches where key_type is null");
        massUpdate.update("update project_branches set key_type=?, updated_at=? where uuid = ?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, DEFAULT_KEY_TYPE);
            update.setLong(2, now);
            update.setString(3, row.getString(1));
            return true;
        });
    }
}

