/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class CreateProjectMappingsTable
extends DdlChange {
    private static final String TABLE_NAME = "project_mappings";
    private static final VarcharColumnDef UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef KEY_TYPE_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("key_type").setIsNullable(false).setLimit(200).build();
    private static final VarcharColumnDef KEE_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("kee").setIsNullable(false).setLimit(4000).build();
    private static final VarcharColumnDef PROJECT_UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("project_uuid").setIsNullable(false).setLimit(40).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();

    public CreateProjectMappingsTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID_COLUMN, new CreateTableBuilder.ColumnFlag[0]).addColumn(KEY_TYPE_COLUMN).addColumn(KEE_COLUMN).addColumn(PROJECT_UUID).addColumn(CREATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(KEY_TYPE_COLUMN).addColumn(KEE_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("key_type_kee").build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(PROJECT_UUID).setUnique(false).setTable(TABLE_NAME).setName("project_uuid").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

