/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.AlterColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.DropIndexBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class MakeSomeColumnsOfUsersNotNullable
extends DdlChange {
    public static final String USERS_TABLE = "users";
    public static final String USERS_LOGIN_INDEX = "users_login";

    public MakeSomeColumnsOfUsersNotNullable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(USERS_TABLE).setName(USERS_LOGIN_INDEX).build());
        context.execute(new AlterColumnsBuilder(this.getDialect(), USERS_TABLE).updateColumn(MakeSomeColumnsOfUsersNotNullable.notNullableColumn("uuid", 255)).updateColumn(MakeSomeColumnsOfUsersNotNullable.notNullableColumn("login", 255)).updateColumn(MakeSomeColumnsOfUsersNotNullable.notNullableColumn("external_id", 255)).updateColumn(MakeSomeColumnsOfUsersNotNullable.notNullableColumn("external_login", 255)).updateColumn(MakeSomeColumnsOfUsersNotNullable.notNullableColumn("external_identity_provider", 100)).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(USERS_TABLE).setName(USERS_LOGIN_INDEX).addColumn(MakeSomeColumnsOfUsersNotNullable.notNullableColumn("login", 255)).setUnique(true).build());
    }

    private static VarcharColumnDef notNullableColumn(String columnName, int limit) {
        return VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName(columnName).setLimit(limit).setIsNullable(false).build();
    }
}

