/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.DropIndexBuilder;
import org.sonar.server.platform.db.migration.sql.RenameColumnsBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class RenameLoginToUserUuidOnTableUserTokens
extends DdlChange {
    private static final String USER_TOKENS_TABLE = "user_tokens";

    public RenameLoginToUserUuidOnTableUserTokens(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(USER_TOKENS_TABLE).setName("user_tokens_login_name").build());
        VarcharColumnDef userUuidColumn = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("user_uuid").setLimit(255).setIsNullable(false).build();
        context.execute(new RenameColumnsBuilder(this.getDialect(), USER_TOKENS_TABLE).renameColumn("login", userUuidColumn).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(USER_TOKENS_TABLE).setName("user_tokens_user_uuid_name").setUnique(true).addColumn(userUuidColumn).addColumn(VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("name").setLimit(100).setIsNullable(false).build()).build());
    }
}

