/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class UpdateNullValuesFromExternalColumnsAndLoginOfUsers
extends DataChange {
    private static final Logger LOG = Loggers.get(UpdateNullValuesFromExternalColumnsAndLoginOfUsers.class);
    private final System2 system2;
    private UuidFactory uuidFactory;

    public UpdateNullValuesFromExternalColumnsAndLoginOfUsers(Database db, System2 system2, UuidFactory uuidFactory) {
        super(db);
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("users");
        massUpdate.select("SELECT id, login FROM users WHERE login IS NULL OR external_login IS NULL OR external_identity_provider IS NULL");
        massUpdate.update("UPDATE users SET login=?, external_login=?, external_identity_provider=?, updated_at=? WHERE id=?");
        long now = this.system2.now();
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            long id = row.getLong(1);
            String login = row.getString(2);
            if (login == null) {
                LOG.warn("No login has been found for user id '{}'. A UUID has been generated to not have null value.", (Object)id);
                login = this.uuidFactory.create();
            }
            update.setString(1, login);
            update.setString(2, login);
            update.setString(3, "sonarqube");
            update.setLong(4, now);
            update.setLong(5, id);
            return true;
        });
    }
}

