/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class FixMissingQualityProfilesOnOrganizations
extends DataChange {
    private final System2 system2;
    private final UuidFactory uuidFactory;
    private final Configuration configuration;
    private final String as;

    public FixMissingQualityProfilesOnOrganizations(Database db, System2 system2, UuidFactory uuidFactory, Configuration configuration) {
        super(db);
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
        this.configuration = configuration;
        this.as = db.getDialect().getId().equals("mysql") || db.getDialect().getId().equals("mssql") ? " AS " : "";
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        if (!this.configuration.getBoolean("sonar.sonarcloud.enabled").orElse(false).booleanValue()) {
            return;
        }
        long now = this.system2.now();
        this.insertMissingOrgQProfiles(context, now);
        this.insertMissingDefaultQProfiles(context, now);
    }

    private void insertMissingOrgQProfiles(DataChange.Context context, long now) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("Organization quality profiles");
        massUpdate.select("SELECT o.uuid, rp.kee FROM organizations " + this.as + " o, rules_profiles " + this.as + " rp WHERE rp.is_built_in = ? AND NOT EXISTS(SELECT (1) FROM org_qprofiles oqp WHERE oqp.organization_uuid = o.uuid AND oqp.rules_profile_uuid = rp.kee)").setBoolean(1, true);
        massUpdate.update("INSERT INTO org_qprofiles (uuid, organization_uuid, rules_profile_uuid, created_at, updated_at) VALUES(?, ?, ?, ?, ?)");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String organizationUuid = row.getString(1);
            String rulesProfileUuid = row.getString(2);
            update.setString(1, this.uuidFactory.create());
            update.setString(2, organizationUuid);
            update.setString(3, rulesProfileUuid);
            update.setLong(4, now);
            update.setLong(5, now);
            return true;
        });
    }

    private void insertMissingDefaultQProfiles(DataChange.Context context, long now) throws SQLException {
        String defaultRulesProfileKees = FixMissingQualityProfilesOnOrganizations.reduceBuiltInQualityProfiles(context).stream().map(qp -> "'" + ((BuiltInQProfile)qp).kee + "'").collect(Collectors.joining(","));
        if (defaultRulesProfileKees.isEmpty()) {
            return;
        }
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("Organization default quality profiles");
        massUpdate.select("SELECT o.uuid, oqp.uuid, rp.language FROM organizations " + this.as + " o, org_qprofiles " + this.as + " oqp, rules_profiles " + this.as + " rp WHERE oqp.rules_profile_uuid = rp.kee AND oqp.organization_uuid = o.uuid AND rp.kee IN ( " + defaultRulesProfileKees + " ) AND NOT EXISTS(SELECT(1) FROM default_qprofiles dqp WHERE dqp.organization_uuid = o.uuid AND dqp.language = rp.language)");
        massUpdate.update("INSERT INTO default_qprofiles (organization_uuid, language, qprofile_uuid, created_at, updated_at) VALUES(?, ?, ?, ?, ?)");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String organizationUuid = row.getString(1);
            String orgQProfileUuid = row.getString(2);
            String language = row.getString(3);
            update.setString(1, organizationUuid);
            update.setString(2, language);
            update.setString(3, orgQProfileUuid);
            update.setLong(4, now);
            update.setLong(5, now);
            return true;
        });
    }

    private static List<BuiltInQProfile> reduceBuiltInQualityProfiles(DataChange.Context context) throws SQLException {
        ArrayListMultimap builtInQPByLanguages = ArrayListMultimap.create();
        List<BuiltInQProfile> builtInQProfiles = ((Select)context.prepareSelect("SELECT kee, language, name FROM rules_profiles WHERE is_built_in = ?").setBoolean(1, true)).list(row -> new BuiltInQProfile(row.getString(1), row.getString(2), row.getString(3)));
        builtInQProfiles.forEach(arg_0 -> FixMissingQualityProfilesOnOrganizations.lambda$reduceBuiltInQualityProfiles$4((ListMultimap)builtInQPByLanguages, arg_0));
        builtInQPByLanguages.keySet().forEach(arg_0 -> FixMissingQualityProfilesOnOrganizations.lambda$reduceBuiltInQualityProfiles$7((ListMultimap)builtInQPByLanguages, builtInQProfiles, arg_0));
        return builtInQProfiles;
    }

    private static /* synthetic */ void lambda$reduceBuiltInQualityProfiles$7(ListMultimap builtInQPByLanguages, List builtInQProfiles, String l) {
        List qps = builtInQPByLanguages.get((Object)l);
        if (qps.size() > 1) {
            BuiltInQProfile sonarWay = qps.stream().filter(qp -> ((BuiltInQProfile)qp).name.equals("Sonar way")).findFirst().orElse((BuiltInQProfile)qps.get(0));
            qps.forEach(qp -> {
                if (((BuiltInQProfile)qp).kee.equals(sonarWay.kee)) {
                    return;
                }
                builtInQProfiles.remove(qp);
            });
        }
    }

    private static /* synthetic */ void lambda$reduceBuiltInQualityProfiles$4(ListMultimap builtInQPByLanguages, BuiltInQProfile builtInQProfile) {
        builtInQPByLanguages.put((Object)builtInQProfile.language, (Object)builtInQProfile);
    }

    private static class BuiltInQProfile {
        private final String kee;
        private final String language;
        private final String name;

        public BuiltInQProfile(String kee, String language, String name) {
            this.kee = kee;
            this.language = language;
            this.name = name;
        }
    }
}

