/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateHotspotAdminPermissionOnTemplatesCharacteristics
extends DataChange {
    private static final String ISSUE_ADMIN_ROLE = "issueadmin";
    private static final String HOTSPOT_ADMIN_ROLE = "securityhotspotadmin";
    private final System2 system2;

    public PopulateHotspotAdminPermissionOnTemplatesCharacteristics(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Date now = new Date(this.system2.now());
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT template_id  FROM perm_tpl_characteristics c1  WHERE permission_key = ?  AND with_project_creator = ?  AND NOT EXISTS (    SELECT id    FROM perm_tpl_characteristics c2    WHERE permission_key = ?    AND c1.template_id = c2.template_id)").setString(1, ISSUE_ADMIN_ROLE).setBoolean(2, true).setString(3, HOTSPOT_ADMIN_ROLE);
        massUpdate.update("INSERT INTO perm_tpl_characteristics (template_id, permission_key, with_project_creator, created_at, updated_at) values (?,?,?,?,?)");
        massUpdate.rowPluralName("permission templates characteristics");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateHotspotAdminPermissionOnTemplatesCharacteristics.handle(row, update, now.getTime()));
    }

    private static boolean handle(Select.Row row, SqlStatement update, long now) throws SQLException {
        int templateId = row.getInt(1);
        update.setInt(1, templateId);
        update.setString(2, HOTSPOT_ADMIN_ROLE);
        update.setBoolean(3, true);
        update.setLong(4, now);
        update.setLong(5, now);
        return true;
    }
}

