/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.BooleanColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.AlterColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.DropColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.DropIndexBuilder;
import org.sonar.server.platform.db.migration.sql.RenameColumnsBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class FinalizeMainLastKeyColumnsToCeActivity
extends DdlChange {
    private static final String TABLE_NAME = "ce_activity";
    private static final int TASK_TYPE_COLUMN_SIZE = 15;
    private static final BooleanColumnDef COLUMN_IS_LAST = BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("is_last").setIsNullable(false).build();
    private static final VarcharColumnDef COLUMN_IS_LAST_KEY = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("is_last_key").setLimit(55).setIsNullable(false).build();
    private static final BooleanColumnDef COLUMN_MAIN_IS_LAST = BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("main_is_last").setIsNullable(false).build();
    private static final VarcharColumnDef COLUMN_MAIN_IS_LAST_KEY = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("main_is_last_key").setLimit(55).setIsNullable(false).build();
    private static final VarcharColumnDef COLUMN_STATUS = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("status").setLimit(15).setIsNullable(false).build();

    public FinalizeMainLastKeyColumnsToCeActivity(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_islastkey").build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_islast_status").build());
        context.execute(new DropColumnsBuilder(this.getDialect(), TABLE_NAME, COLUMN_IS_LAST.getName(), COLUMN_IS_LAST_KEY.getName()).build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_t_islast_key").build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_t_islast").build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_t_main_islast_key").build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_t_main_islast").build());
        context.execute(new RenameColumnsBuilder(this.getDialect(), TABLE_NAME).renameColumn("tmp_is_last", COLUMN_IS_LAST).renameColumn("tmp_is_last_key", COLUMN_IS_LAST_KEY).renameColumn("tmp_main_is_last", COLUMN_MAIN_IS_LAST).renameColumn("tmp_main_is_last_key", COLUMN_MAIN_IS_LAST_KEY).build());
        context.execute(new AlterColumnsBuilder(this.getDialect(), TABLE_NAME).updateColumn(COLUMN_IS_LAST).updateColumn(COLUMN_IS_LAST_KEY).updateColumn(COLUMN_MAIN_IS_LAST).updateColumn(COLUMN_MAIN_IS_LAST_KEY).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_islast_key").addColumn(COLUMN_IS_LAST_KEY).setUnique(false).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_islast").addColumn(COLUMN_IS_LAST).addColumn(COLUMN_STATUS).setUnique(false).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_main_islast_key").addColumn(COLUMN_MAIN_IS_LAST_KEY).setUnique(false).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(TABLE_NAME).setName("ce_activity_main_islast").addColumn(COLUMN_MAIN_IS_LAST).addColumn(COLUMN_STATUS).setUnique(false).build());
    }
}

