/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateDefaultPermTemplateOnOrganizations
extends DataChange {
    private final System2 system2;

    public PopulateDefaultPermTemplateOnOrganizations(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("organizations");
        massUpdate.select("SELECT uuid, default_perm_template_view FROM organizations WHERE default_perm_template_view IS NOT NULL");
        massUpdate.update("UPDATE organizations SET default_perm_template_app=?, default_perm_template_port=?, updated_at=? WHERE uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String uuid = row.getString(1);
            String defaultPermTemplateView = row.getString(2);
            update.setString(1, defaultPermTemplateView);
            update.setString(2, defaultPermTemplateView);
            update.setLong(3, now);
            update.setString(4, uuid);
            return true;
        });
    }
}

