/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.container;

import java.util.List;
import java.util.Objects;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.monitors.NullComponentMonitor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.container.EagerStart;
import org.sonar.ce.task.container.TaskContainer;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.ContainerPopulator;
import org.sonar.core.platform.Module;
import org.sonar.core.platform.StopSafeReflectionLifecycleStrategy;

public class TaskContainerImpl
extends ComponentContainer
implements TaskContainer {
    public TaskContainerImpl(ComponentContainer parent, ContainerPopulator<TaskContainer> populator) {
        super(TaskContainerImpl.createContainer(Objects.requireNonNull(parent)), (PropertyDefinitions)parent.getComponentByType(PropertyDefinitions.class));
        this.populateContainer(Objects.requireNonNull(populator));
    }

    private void populateContainer(ContainerPopulator<TaskContainer> populator) {
        populator.populateContainer((ContainerPopulator.Container)this);
        this.populateFromModules();
    }

    private void populateFromModules() {
        List modules = this.getComponentsByType(Module.class);
        for (Module module : modules) {
            module.configure((ComponentContainer)this);
        }
    }

    private static MutablePicoContainer createContainer(ComponentContainer parent) {
        NullComponentMonitor componentMonitor = new NullComponentMonitor();
        StopSafeReflectionLifecycleStrategy lifecycleStrategy = new StopSafeReflectionLifecycleStrategy((ComponentMonitor)componentMonitor){

            public boolean isLazy(ComponentAdapter<?> adapter) {
                return adapter.getComponentImplementation().getAnnotation(EagerStart.class) == null;
            }
        };
        return new DefaultPicoContainer((ComponentFactory)new OptInCaching(), (LifecycleStrategy)lifecycleStrategy, (PicoContainer)parent.getPicoContainer(), (ComponentMonitor)componentMonitor);
    }

    @Override
    public void bootup() {
        this.startComponents();
    }

    public String toString() {
        return "TaskContainerImpl";
    }

    @Override
    public void close() {
        try {
            this.stopComponents();
        }
        catch (Throwable t) {
            Loggers.get(TaskContainerImpl.class).error("Cleanup of container failed", t);
        }
    }
}

