/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.css.plugin.LinterCommandProvider;

@ScannerSide
public class StylelintCommandProvider
implements LinterCommandProvider {
    private static final Logger LOG = Loggers.get(StylelintCommandProvider.class);
    private static final String CONFIG_PATH = "css-bundle/stylelintconfig.json";
    private static final String NODE_EXECUTABLE_DEFAULT = "node";
    private String nodeExecutable = null;

    @Override
    public String[] commandParts(File deployDestination, SensorContext context) {
        String projectBaseDir = context.fileSystem().baseDir().getAbsolutePath();
        CharSequence[] suffixes = context.config().getStringArray("sonar.css.file.suffixes");
        String filesGlob = "**" + File.separator + "*{" + String.join((CharSequence)",", suffixes) + "}";
        String filesToAnalyze = Paths.get(projectBaseDir, "TOREPLACE").toString();
        filesToAnalyze = filesToAnalyze.replace("TOREPLACE", filesGlob);
        return new String[]{this.nodeExecutable(context.config()), new File(deployDestination, "css-bundle/node_modules/stylelint/bin/stylelint").getAbsolutePath(), filesToAnalyze, "--config", new File(deployDestination, CONFIG_PATH).getAbsolutePath(), "-f", "json"};
    }

    @Override
    public String configPath(File deployDestination) {
        return new File(deployDestination, CONFIG_PATH).getAbsolutePath();
    }

    @Override
    public String nodeExecutable(Configuration configuration) {
        if (this.nodeExecutable == null) {
            this.nodeExecutable = StylelintCommandProvider.retrieveNodeExecutableFromConfig(configuration);
        }
        return this.nodeExecutable;
    }

    private static String retrieveNodeExecutableFromConfig(Configuration configuration) {
        Optional nodeExecutableOptional = configuration.get("sonar.css.node");
        if (nodeExecutableOptional.isPresent()) {
            String nodeExecutable = (String)nodeExecutableOptional.get();
            File file = new File(nodeExecutable);
            if (file.exists()) {
                return nodeExecutable;
            }
            LOG.warn("Provided node executable file does not exist: " + file + ". Fallback to using 'node' from path.");
        }
        return NODE_EXECUTABLE_DEFAULT;
    }
}

