/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.sonar.process.FileUtils2;
import org.sonar.process.Props;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static Properties interpolateVariables(Properties properties, Map<String, String> variables) {
        Properties result = new Properties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)properties.get(key);
            String interpolatedValue = StrSubstitutor.replace((Object)value, variables, (String)"${env:", (String)"}");
            result.setProperty(key, interpolatedValue);
        }
        return result;
    }

    static Props loadPropsFromCommandLineArgs(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Only a single command-line argument is accepted (absolute path to configuration file)");
        }
        File propertyFile = new File(args[0]);
        Properties properties = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(propertyFile), StandardCharsets.UTF_8);
            properties.load(reader);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Could not read properties from file: " + args[0], e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                FileUtils2.deleteQuietly(propertyFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        FileUtils2.deleteQuietly(propertyFile);
        return new Props(properties);
    }
}

