/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FileUtils2 {
    private static final String DIRECTORY_CAN_NOT_BE_NULL = "Directory can not be null";
    private static final EnumSet<FileVisitOption> FOLLOW_LINKS = EnumSet.of(FileVisitOption.FOLLOW_LINKS);

    private FileUtils2() {
    }

    public static void cleanDirectory(File directory) throws IOException {
        Objects.requireNonNull(directory, DIRECTORY_CAN_NOT_BE_NULL);
        if (!directory.exists()) {
            return;
        }
        FileUtils2.cleanDirectoryImpl(directory.toPath());
    }

    public static boolean deleteQuietly(@Nullable File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils2.deleteDirectory(file);
            } else {
                Files.delete(file.toPath());
            }
            return true;
        }
        catch (IOException | SecurityException ignored) {
            return false;
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        Objects.requireNonNull(directory, DIRECTORY_CAN_NOT_BE_NULL);
        if (!directory.exists()) {
            return;
        }
        Path path = directory.toPath();
        if (Files.isSymbolicLink(path)) {
            throw new IOException(String.format("Directory '%s' is a symbolic link", directory));
        }
        if (directory.isFile()) {
            throw new IOException(String.format("Directory '%s' is a file", directory));
        }
        FileUtils2.deleteDirectoryImpl(path);
        if (directory.exists()) {
            throw new IOException(String.format("Unable to delete directory '%s'", directory));
        }
    }

    public static long sizeOf(Path path) throws IOException {
        SizeVisitor visitor = new SizeVisitor();
        Files.walkFileTree(path, visitor);
        return visitor.size;
    }

    private static void cleanDirectoryImpl(Path path) throws IOException {
        if (!path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("'%s' is not a directory", path));
        }
        Files.walkFileTree(path, FOLLOW_LINKS, 1, new CleanDirectoryFileVisitor(path));
    }

    private static void deleteDirectoryImpl(Path path) throws IOException {
        Files.walkFileTree(path, DeleteRecursivelyFileVisitor.INSTANCE);
    }

    private static final class SizeVisitor
    extends SimpleFileVisitor<Path> {
        private long size = 0L;

        private SizeVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (attrs.isRegularFile()) {
                this.size += attrs.size();
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class DeleteRecursivelyFileVisitor
    extends SimpleFileVisitor<Path> {
        public static final DeleteRecursivelyFileVisitor INSTANCE = new DeleteRecursivelyFileVisitor();

        private DeleteRecursivelyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class CleanDirectoryFileVisitor
    extends SimpleFileVisitor<Path> {
        public static final int VISIT_MAX_DEPTH = 1;
        private final Path path;
        private final boolean symLink;

        public CleanDirectoryFileVisitor(Path path) {
            this.path = path;
            this.symLink = Files.isSymbolicLink(path);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().isDirectory()) {
                FileUtils2.deleteDirectoryImpl(file);
            } else if (!this.symLink || !file.equals(this.path)) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (!dir.equals(this.path)) {
                FileUtils2.deleteDirectoryImpl(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

