/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(Lifecycle.class);
    private static final Map<State, Set<State>> TRANSITIONS = Lifecycle.buildTransitions();
    private State state = State.INIT;

    private static Map<State, Set<State>> buildTransitions() {
        EnumMap<State, Set<State>> res = new EnumMap<State, Set<State>>(State.class);
        res.put(State.INIT, Lifecycle.toSet(State.STARTING));
        res.put(State.STARTING, Lifecycle.toSet(State.STARTED, State.STOPPING, State.HARD_STOPPING));
        res.put(State.STARTED, Lifecycle.toSet(State.OPERATIONAL, State.RESTARTING, State.STOPPING, State.HARD_STOPPING));
        res.put(State.OPERATIONAL, Lifecycle.toSet(State.RESTARTING, State.STOPPING, State.HARD_STOPPING));
        res.put(State.RESTARTING, Lifecycle.toSet(State.STARTING, State.HARD_STOPPING));
        res.put(State.STOPPING, Lifecycle.toSet(State.STOPPED));
        res.put(State.HARD_STOPPING, Lifecycle.toSet(State.STOPPED));
        res.put(State.STOPPED, Lifecycle.toSet(new State[0]));
        return res;
    }

    private static Set<State> toSet(State ... states) {
        if (states.length == 0) {
            return Collections.emptySet();
        }
        if (states.length == 1) {
            return Collections.singleton(states[0]);
        }
        return EnumSet.copyOf(Arrays.asList(states));
    }

    public State getState() {
        return this.state;
    }

    public synchronized boolean tryToMoveTo(State to) {
        boolean res = false;
        State currentState = this.state;
        if (TRANSITIONS.get((Object)currentState).contains((Object)to)) {
            this.state = to;
            res = true;
        }
        LOG.trace("tryToMoveTo from {} to {} => {}", new Object[]{currentState, to, res});
        return res;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lifecycle lifecycle = (Lifecycle)o;
        return this.state == lifecycle.state;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public static enum State {
        INIT,
        STARTING,
        STARTED,
        OPERATIONAL,
        RESTARTING,
        STOPPING,
        HARD_STOPPING,
        STOPPED;

    }
}

