/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.process.NetworkUtils;

public class NetworkUtilsImpl
implements NetworkUtils {
    public static final NetworkUtils INSTANCE = new NetworkUtilsImpl();
    private static final Set<Integer> PORTS_ALREADY_ALLOCATED = new HashSet<Integer>();
    private static final int PORT_MAX_TRIES = 50;

    NetworkUtilsImpl() {
    }

    @Override
    public int getNextAvailablePort(InetAddress address) {
        return NetworkUtilsImpl.getNextAvailablePort(address, PortAllocator.INSTANCE);
    }

    @VisibleForTesting
    static int getNextAvailablePort(InetAddress address, PortAllocator portAllocator) {
        for (int i = 0; i < 50; ++i) {
            int port = portAllocator.getAvailable(address);
            if (!NetworkUtilsImpl.isValidPort(port)) continue;
            PORTS_ALREADY_ALLOCATED.add(port);
            return port;
        }
        throw new IllegalStateException("Fail to find an available port on " + address);
    }

    private static boolean isValidPort(int port) {
        return port > 1023 && !PORTS_ALREADY_ALLOCATED.contains(port);
    }

    @Override
    public String getHostname() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unresolved hostname";
        }
        return hostname;
    }

    @Override
    public InetAddress toInetAddress(String hostOrAddress) throws UnknownHostException {
        if (InetAddresses.isInetAddress((String)hostOrAddress)) {
            return InetAddresses.forString((String)hostOrAddress);
        }
        return InetAddress.getByName(hostOrAddress);
    }

    @Override
    public boolean isLocalInetAddress(InetAddress address) throws SocketException {
        return NetworkInterface.getByInetAddress(address) != null;
    }

    @Override
    public boolean isLoopbackInetAddress(InetAddress address) {
        return address.isLoopbackAddress();
    }

    @Override
    public Optional<InetAddress> getLocalInetAddress(Predicate<InetAddress> predicate) {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(ni -> Collections.list(ni.getInetAddresses()).stream()).filter(a -> a.getHostAddress() != null).filter(predicate).findFirst();
        }
        catch (SocketException e) {
            throw new IllegalStateException("Can not retrieve network interfaces", e);
        }
    }

    static class PortAllocator {
        private static final PortAllocator INSTANCE = new PortAllocator();

        PortAllocator() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int getAvailable(InetAddress address) {
            try (ServerSocket socket = new ServerSocket(0, 50, address);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to find an available port on " + address, e);
            }
        }
    }
}

