/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.hz;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.sonar.process.cluster.hz.DistributedAnswer;
import org.sonar.process.cluster.hz.DistributedCall;
import org.sonar.process.cluster.hz.HazelcastMember;

class HazelcastMemberImpl
implements HazelcastMember {
    private final HazelcastInstance hzInstance;

    HazelcastMemberImpl(HazelcastInstance hzInstance) {
        this.hzInstance = hzInstance;
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return this.hzInstance.getAtomicReference(name);
    }

    @Override
    public <K, V> Map<K, V> getReplicatedMap(String s) {
        return this.hzInstance.getReplicatedMap(s);
    }

    @Override
    public String getUuid() {
        return this.hzInstance.getLocalEndpoint().getUuid();
    }

    @Override
    public Set<String> getMemberUuids() {
        return this.hzInstance.getCluster().getMembers().stream().map(Member::getUuid).collect(Collectors.toSet());
    }

    @Override
    public Lock getLock(String s) {
        return this.hzInstance.getLock(s);
    }

    @Override
    public long getClusterTime() {
        return this.hzInstance.getCluster().getClusterTime();
    }

    @Override
    public Cluster getCluster() {
        return this.hzInstance.getCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> DistributedAnswer<T> call(DistributedCall<T> callable, MemberSelector memberSelector, long timeoutMs) throws InterruptedException {
        IExecutorService executor = this.hzInstance.getExecutorService("default");
        Map futures = executor.submitToMembers(callable, memberSelector);
        try {
            DistributedAnswer distributedAnswer = new DistributedAnswer();
            long maxTime = System.currentTimeMillis() + timeoutMs;
            for (Map.Entry entry : futures.entrySet()) {
                long remainingMs = Math.max(maxTime - System.currentTimeMillis(), 5L);
                try {
                    Object answer = ((Future)entry.getValue()).get(remainingMs, TimeUnit.MILLISECONDS);
                    distributedAnswer.setAnswer((Member)entry.getKey(), answer);
                }
                catch (ExecutionException e) {
                    distributedAnswer.setFailed((Member)entry.getKey(), e);
                }
                catch (TimeoutException e) {
                    distributedAnswer.setTimedOut((Member)entry.getKey());
                }
            }
            DistributedAnswer distributedAnswer2 = distributedAnswer;
            return distributedAnswer2;
        }
        finally {
            futures.values().forEach(f -> f.cancel(true));
        }
    }

    @Override
    public void close() {
        try {
            this.hzInstance.shutdown();
        }
        catch (HazelcastInstanceNotActiveException e) {
            LoggerFactory.getLogger(this.getClass()).debug("Unable to shutdown Hazelcast member", (Throwable)e);
        }
    }
}

