/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.sharedmemoryfile;

import java.io.File;
import org.slf4j.LoggerFactory;
import org.sonar.process.sharedmemoryfile.AllProcessesCommands;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class DefaultProcessCommands
implements ProcessCommands {
    private final AllProcessesCommands allProcessesCommands;
    private final ProcessCommands delegate;

    private DefaultProcessCommands(File directory, int processNumber, boolean clean) {
        this.allProcessesCommands = new AllProcessesCommands(directory);
        this.delegate = clean ? this.allProcessesCommands.createAfterClean(processNumber) : this.allProcessesCommands.create(processNumber);
    }

    public static DefaultProcessCommands main(File directory, int processNumber) {
        return new DefaultProcessCommands(directory, processNumber, true);
    }

    public static DefaultProcessCommands secondary(File directory, int processNumber) {
        return new DefaultProcessCommands(directory, processNumber, false);
    }

    public static void reset(File directory, int processNumber) {
        DefaultProcessCommands processCommands = new DefaultProcessCommands(directory, processNumber, true);
        Throwable throwable = null;
        if (processCommands != null) {
            if (throwable != null) {
                try {
                    processCommands.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                processCommands.close();
            }
        }
    }

    @Override
    public boolean isUp() {
        return this.delegate.isUp();
    }

    @Override
    public void setUp() {
        this.delegate.setUp();
    }

    @Override
    public boolean isOperational() {
        return this.delegate.isOperational();
    }

    @Override
    public void setOperational() {
        this.delegate.setOperational();
    }

    @Override
    public void ping() {
        this.delegate.ping();
    }

    @Override
    public long getLastPing() {
        return this.delegate.getLastPing();
    }

    @Override
    public void setHttpUrl(String s) {
        this.delegate.setHttpUrl(s);
    }

    @Override
    public String getHttpUrl() {
        return this.delegate.getHttpUrl();
    }

    @Override
    public void askForStop() {
        this.delegate.askForStop();
    }

    @Override
    public boolean askedForStop() {
        return this.delegate.askedForStop();
    }

    @Override
    public void askForRestart() {
        this.delegate.askForRestart();
    }

    @Override
    public boolean askedForRestart() {
        return this.delegate.askedForRestart();
    }

    @Override
    public void acknowledgeAskForRestart() {
        this.delegate.acknowledgeAskForRestart();
    }

    @Override
    public void endWatch() {
        try {
            this.close();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Failed to close DefaultProcessCommands", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.allProcessesCommands.close();
    }
}

