/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;

@Rule(key="S1778")
public class CharBeforePrologCheck
extends SonarXmlCheck {
    public static final String RULE_KEY = "S1778";

    @Override
    public void scanFile(XmlFile file) {
        file.getPrologElement().ifPresent(prologElement -> {
            XmlTextRange prologStartLocation = prologElement.getPrologStartLocation();
            if (prologStartLocation.getStartLine() != 1 || prologStartLocation.getStartColumn() != 0) {
                this.reportIssue(prologStartLocation, "Remove all characters located before \"<?xml\".", Collections.emptyList());
            }
        });
    }
}

