/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.operation.BasePutOperation;
import com.hazelcast.map.impl.operation.PutBackupOperation;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MergeOperation
extends BasePutOperation {
    private MapMergePolicy mergePolicy;
    private EntryView<Data, Data> mergingEntry;
    private boolean merged;
    private Data mergingValue;
    private boolean disableWanReplicationEvent;

    public MergeOperation(String name, Data dataKey, EntryView<Data, Data> entryView, MapMergePolicy policy) {
        this(name, dataKey, entryView, policy, false);
    }

    public MergeOperation(String name, Data dataKey, EntryView<Data, Data> entryView, MapMergePolicy policy, boolean disableWanReplicationEvent) {
        super(name, dataKey, null);
        this.mergingEntry = entryView;
        this.mergePolicy = policy;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    public MergeOperation() {
    }

    @Override
    public void run() {
        Object record;
        Object oldRecord = this.recordStore.getRecord(this.dataKey);
        if (oldRecord != null) {
            this.dataOldValue = this.mapServiceContext.toData(oldRecord.getValue());
        }
        this.merged = this.recordStore.merge(this.dataKey, this.mergingEntry, this.mergePolicy);
        if (this.merged && (record = this.recordStore.getRecord(this.dataKey)) != null) {
            this.dataValue = this.mapServiceContext.toData(record.getValue());
            this.mergingValue = this.mapServiceContext.toData(this.mergingEntry.getValue());
        }
    }

    @Override
    public Object getResponse() {
        return this.merged;
    }

    @Override
    public boolean shouldBackup() {
        return this.merged;
    }

    @Override
    public void afterRun() {
        if (this.merged) {
            this.mapServiceContext.interceptAfterPut(this.name, this.dataValue);
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.MERGED, this.dataKey, this.dataOldValue, this.dataValue, this.mergingValue);
            this.invalidateNearCache(this.dataKey);
            this.evict(this.dataKey);
        }
    }

    @Override
    public Operation getBackupOperation() {
        if (this.dataValue == null) {
            return new RemoveBackupOperation(this.name, this.dataKey, false, this.disableWanReplicationEvent);
        }
        Object record = this.recordStore.getRecord(this.dataKey);
        RecordInfo replicationInfo = Records.buildRecordInfo(record);
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo, false, false, this.disableWanReplicationEvent);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (EntryView)in.readObject();
        this.mergePolicy = (MapMergePolicy)in.readObject();
        this.disableWanReplicationEvent = in.readBoolean();
    }

    @Override
    public int getId() {
        return 35;
    }
}

