/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.LdapAutodiscovery;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapGroupMapping;
import org.sonar.plugins.ldap.LdapSearch;

public class LdapUserMapping {
    private static final Logger LOG = Loggers.get(LdapUserMapping.class);
    private static final String DEFAULT_OBJECT_CLASS = "inetOrgPerson";
    private static final String DEFAULT_LOGIN_ATTRIBUTE = "uid";
    private static final String DEFAULT_NAME_ATTRIBUTE = "cn";
    private static final String DEFAULT_EMAIL_ATTRIBUTE = "mail";
    private static final String DEFAULT_REQUEST = "(&(objectClass=inetOrgPerson)(uid={login}))";
    private final String baseDn;
    private final String request;
    private final String realNameAttribute;
    private final String emailAttribute;

    public LdapUserMapping(Settings settings, String settingsPrefix) {
        String req;
        String realm;
        String usesrBaseDnSettingKey = settingsPrefix + ".user.baseDn";
        String usersBaseDn = settings.getString(usesrBaseDnSettingKey);
        if (usersBaseDn == null && (realm = settings.getString(settingsPrefix + ".realm")) != null) {
            LOG.warn("Auto-discovery feature is deprecated, please use '{}' to specify user search dn", (Object)usesrBaseDnSettingKey);
            usersBaseDn = LdapAutodiscovery.getDnsDomainDn(realm);
        }
        String objectClass = settings.getString(settingsPrefix + ".user.objectClass");
        String loginAttribute = settings.getString(settingsPrefix + ".user.loginAttribute");
        this.baseDn = usersBaseDn;
        this.realNameAttribute = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".user.realNameAttribute"), (String)DEFAULT_NAME_ATTRIBUTE);
        this.emailAttribute = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".user.emailAttribute"), (String)DEFAULT_EMAIL_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)objectClass) || StringUtils.isNotBlank((String)loginAttribute)) {
            objectClass = StringUtils.defaultString((String)objectClass, (String)DEFAULT_OBJECT_CLASS);
            loginAttribute = StringUtils.defaultString((String)loginAttribute, (String)DEFAULT_LOGIN_ATTRIBUTE);
            req = "(&(objectClass=" + objectClass + ")(" + loginAttribute + "={login}))";
            Loggers.get(LdapGroupMapping.class).warn("Properties '{}.user.objectClass' and '{}.user.loginAttribute' are deprecated and should be replaced by single property '{}.user.request' with value: {}", new Object[]{settingsPrefix, settingsPrefix, settingsPrefix, req});
        } else {
            req = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".user.request"), (String)DEFAULT_REQUEST);
        }
        this.request = req = StringUtils.replace((String)req, (String)"{login}", (String)"{0}");
    }

    public LdapSearch createSearch(LdapContextFactory contextFactory, String username) {
        return new LdapSearch(contextFactory).setBaseDn(this.getBaseDn()).setRequest(this.getRequest()).setParameters(username);
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public String getRequest() {
        return this.request;
    }

    public String getRealNameAttribute() {
        return this.realNameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{baseDn=" + this.getBaseDn() + ", request=" + this.getRequest() + ", realNameAttribute=" + this.getRealNameAttribute() + ", emailAttribute=" + this.getEmailAttribute() + "}";
    }
}

