/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.monitoring;

import org.apache.commons.dbcp2.BasicDataSource;
import org.picocontainer.Startable;
import org.sonar.ce.monitoring.CeDatabaseMBean;
import org.sonar.db.DbClient;
import org.sonar.process.Jmx;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class CeDatabaseMBeanImpl
implements CeDatabaseMBean,
Startable,
SystemInfoSection {
    private final DbClient dbClient;

    public CeDatabaseMBeanImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void start() {
        Jmx.register((String)"SonarQube:name=ComputeEngineDatabaseConnection", (Object)this);
    }

    public void stop() {
        Jmx.unregister((String)"SonarQube:name=ComputeEngineDatabaseConnection");
    }

    @Override
    public int getPoolActiveConnections() {
        return this.commonsDbcp().getNumActive();
    }

    @Override
    public int getPoolMaxActiveConnections() {
        return this.commonsDbcp().getMaxTotal();
    }

    @Override
    public int getPoolIdleConnections() {
        return this.commonsDbcp().getNumIdle();
    }

    @Override
    public int getPoolMaxIdleConnections() {
        return this.commonsDbcp().getMaxIdle();
    }

    @Override
    public int getPoolMinIdleConnections() {
        return this.commonsDbcp().getMinIdle();
    }

    @Override
    public int getPoolInitialSize() {
        return this.commonsDbcp().getInitialSize();
    }

    @Override
    public long getPoolMaxWaitMillis() {
        return this.commonsDbcp().getMaxWaitMillis();
    }

    @Override
    public boolean getPoolRemoveAbandoned() {
        return this.commonsDbcp().getRemoveAbandonedOnBorrow();
    }

    @Override
    public int getPoolRemoveAbandonedTimeoutSeconds() {
        return this.commonsDbcp().getRemoveAbandonedTimeout();
    }

    private BasicDataSource commonsDbcp() {
        return (BasicDataSource)this.dbClient.getDatabase().getDataSource();
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder builder = ProtobufSystemInfo.Section.newBuilder();
        builder.setName("Compute Engine Database Connection");
        builder.addAttributesBuilder().setKey("Pool Initial Size").setLongValue((long)this.getPoolInitialSize()).build();
        builder.addAttributesBuilder().setKey("Pool Active Connections").setLongValue((long)this.getPoolActiveConnections()).build();
        builder.addAttributesBuilder().setKey("Pool Idle Connections").setLongValue((long)this.getPoolIdleConnections()).build();
        builder.addAttributesBuilder().setKey("Pool Max Active Connections").setLongValue((long)this.getPoolMaxActiveConnections()).build();
        builder.addAttributesBuilder().setKey("Pool Max Idle Connections").setLongValue((long)this.getPoolMaxIdleConnections()).build();
        builder.addAttributesBuilder().setKey("Pool Min Idle Connections").setLongValue((long)this.getPoolMinIdleConnections()).build();
        builder.addAttributesBuilder().setKey("Pool Max Wait (ms)").setLongValue(this.getPoolMaxWaitMillis()).build();
        builder.addAttributesBuilder().setKey("Pool Remove Abandoned").setBooleanValue(this.getPoolRemoveAbandoned()).build();
        builder.addAttributesBuilder().setKey("Pool Remove Abandoned Timeout (sec)").setLongValue((long)this.getPoolRemoveAbandonedTimeoutSeconds()).build();
        return builder.build();
    }
}

