/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import java.util.Collection;
import java.util.List;
import org.picocontainer.Startable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.ServerUpgradeStatus;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.queue.InternalCeQueue;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.process.ProcessProperties;

@ComputeEngineSide
public class CeQueueCleaner
implements Startable {
    private static final Logger LOGGER = Loggers.get(CeQueueCleaner.class);
    private final DbClient dbClient;
    private final ServerUpgradeStatus serverUpgradeStatus;
    private final InternalCeQueue queue;
    private final Configuration configuration;

    public CeQueueCleaner(DbClient dbClient, ServerUpgradeStatus serverUpgradeStatus, InternalCeQueue queue, Configuration configuration) {
        this.dbClient = dbClient;
        this.serverUpgradeStatus = serverUpgradeStatus;
        this.queue = queue;
        this.configuration = configuration;
    }

    public void start() {
        if (this.serverUpgradeStatus.isUpgraded() && !this.isBlueGreenDeployment()) {
            this.cleanOnUpgrade();
        }
        this.cleanUpTaskInputOrphans();
    }

    private boolean isBlueGreenDeployment() {
        return this.configuration.getBoolean(ProcessProperties.Property.BLUE_GREEN_ENABLED.getKey()).orElse(false);
    }

    private void cleanOnUpgrade() {
        LOGGER.info("Cancel all pending tasks (due to upgrade)");
        this.queue.clear();
    }

    private void cleanUpTaskInputOrphans() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List uuids = this.dbClient.ceTaskInputDao().selectUuidsNotInQueue(dbSession);
            this.dbClient.ceTaskInputDao().deleteByUuids(dbSession, (Collection)uuids);
            dbSession.commit();
        }
    }

    public void stop() {
    }
}

