/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.container.ComputeEngineStatus;
import org.sonar.ce.monitoring.CEQueueStatus;
import org.sonar.ce.queue.CeQueue;
import org.sonar.ce.queue.CeQueueImpl;
import org.sonar.ce.queue.InternalCeQueue;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.CeTaskResult;
import org.sonar.ce.task.TypedException;
import org.sonar.ce.task.projectanalysis.component.VisitException;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDao;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.ce.CeTaskCharacteristicDto;
import org.sonar.server.organization.DefaultOrganizationProvider;

@ComputeEngineSide
public class InternalCeQueueImpl
extends CeQueueImpl
implements InternalCeQueue {
    private static final Logger LOG = Loggers.get(InternalCeQueueImpl.class);
    private final DbClient dbClient;
    private final CEQueueStatus queueStatus;
    private final ComputeEngineStatus computeEngineStatus;

    public InternalCeQueueImpl(System2 system2, DbClient dbClient, UuidFactory uuidFactory, CEQueueStatus queueStatus, DefaultOrganizationProvider defaultOrganizationProvider, ComputeEngineStatus computeEngineStatus) {
        super(system2, dbClient, uuidFactory, defaultOrganizationProvider);
        this.dbClient = dbClient;
        this.queueStatus = queueStatus;
        this.computeEngineStatus = computeEngineStatus;
    }

    @Override
    public Optional<CeTask> peek(String workerUuid) {
        Objects.requireNonNull(workerUuid, "workerUuid can't be null");
        if (this.computeEngineStatus.getStatus() != ComputeEngineStatus.Status.STARTED || this.getWorkersPauseStatus() != CeQueue.WorkersPauseStatus.RESUMED) {
            return Optional.empty();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional opt;
            CeQueueDao ceQueueDao = this.dbClient.ceQueueDao();
            int i = ceQueueDao.resetToPendingForWorker(dbSession, workerUuid);
            if (i > 0) {
                dbSession.commit();
                LOG.debug("{} in progress tasks reset for worker uuid {}", (Object)i, (Object)workerUuid);
            }
            if ((opt = ceQueueDao.peek(dbSession, workerUuid)).isPresent()) {
                CeQueueDto taskDto = (CeQueueDto)opt.get();
                Map componentsByUuid = this.loadComponentDtos(dbSession, taskDto);
                Map characteristics = (Map)this.dbClient.ceTaskCharacteristicsDao().selectByTaskUuids(dbSession, Collections.singletonList(taskDto.getUuid())).stream().collect(MoreCollectors.uniqueIndex(CeTaskCharacteristicDto::getKey, CeTaskCharacteristicDto::getValue));
                CeTask task = this.convertToTask(dbSession, taskDto, characteristics, Optional.ofNullable(taskDto.getComponentUuid()).map(componentsByUuid::get).orElse(null), Optional.ofNullable(taskDto.getMainComponentUuid()).map(componentsByUuid::get).orElse(null));
                this.queueStatus.addInProgress();
                Optional<CeTask> optional = Optional.of(task);
                return optional;
            }
            Optional<CeTask> optional = Optional.empty();
            return optional;
        }
    }

    @Override
    public int clear() {
        return this.cancelAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CeTask task, CeActivityDto.Status status, @Nullable CeTaskResult taskResult, @Nullable Throwable error) {
        Preconditions.checkArgument((error == null || status == CeActivityDto.Status.FAILED ? 1 : 0) != 0, (Object)"Error can be provided only when status is FAILED");
        long executionTimeInMs = 0L;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            CeQueueDto queueDto = (CeQueueDto)this.dbClient.ceQueueDao().selectByUuid(dbSession, task.getUuid()).orElseThrow(() -> new IllegalStateException("Task does not exist anymore: " + task));
            CeActivityDto activityDto = new CeActivityDto(queueDto);
            activityDto.setStatus(status);
            executionTimeInMs = this.updateExecutionFields(activityDto);
            InternalCeQueueImpl.updateTaskResult(activityDto, taskResult);
            InternalCeQueueImpl.updateError(activityDto, error);
            this.remove(dbSession, queueDto, activityDto);
        }
        finally {
            this.updateQueueStatus(status, executionTimeInMs);
        }
    }

    private void updateQueueStatus(CeActivityDto.Status status, long executionTimeInMs) {
        if (status == CeActivityDto.Status.SUCCESS) {
            this.queueStatus.addSuccess(executionTimeInMs);
        } else {
            this.queueStatus.addError(executionTimeInMs);
        }
    }

    private static void updateTaskResult(CeActivityDto activityDto, @Nullable CeTaskResult taskResult) {
        if (taskResult != null) {
            Optional analysisUuid = taskResult.getAnalysisUuid();
            analysisUuid.ifPresent(arg_0 -> ((CeActivityDto)activityDto).setAnalysisUuid(arg_0));
        }
    }

    private static void updateError(CeActivityDto activityDto, @Nullable Throwable error) {
        if (error == null) {
            return;
        }
        if (error instanceof VisitException && error.getCause() != null) {
            activityDto.setErrorMessage(String.format("%s (%s)", error.getCause().getMessage(), error.getMessage()));
        } else {
            activityDto.setErrorMessage(error.getMessage());
        }
        String stacktrace = InternalCeQueueImpl.getStackTraceForPersistence(error);
        if (stacktrace != null) {
            activityDto.setErrorStacktrace(stacktrace);
        }
        if (error instanceof TypedException) {
            activityDto.setErrorType(((TypedException)error).getType());
        }
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    private static String getStackTraceForPersistence(Throwable error) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void cancelWornOuts() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List wornOutTasks = this.dbClient.ceQueueDao().selectWornout(dbSession);
            wornOutTasks.forEach(queueDto -> {
                CeActivityDto activityDto = new CeActivityDto(queueDto);
                activityDto.setStatus(CeActivityDto.Status.CANCELED);
                this.updateExecutionFields(activityDto);
                this.remove(dbSession, (CeQueueDto)queueDto, activityDto);
            });
        }
    }

    @Override
    public void resetTasksWithUnknownWorkerUUIDs(Set<String> knownWorkerUUIDs) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.ceQueueDao().resetTasksWithUnknownWorkerUUIDs(dbSession, knownWorkerUUIDs);
            dbSession.commit();
        }
    }

    private static class LineReturnEnforcedPrintStream
    extends PrintWriter {
        LineReturnEnforcedPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void println() {
            super.print('\n');
        }

        @Override
        public void println(boolean x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(char x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(int x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(long x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(float x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(double x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(char[] x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(String x) {
            super.print(x);
            this.println();
        }

        @Override
        public void println(Object x) {
            super.print(x);
            this.println();
        }
    }
}

