/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.sonar.ce.configuration.CeConfiguration;
import org.sonar.ce.taskprocessor.CeProcessingSchedulerExecutorService;
import org.sonar.server.util.AbstractStoppableExecutorService;

public class CeProcessingSchedulerExecutorServiceImpl
extends AbstractStoppableExecutorService<ListeningScheduledExecutorService>
implements CeProcessingSchedulerExecutorService {
    private static final String THREAD_NAME_PREFIX = "ce-worker-";

    public CeProcessingSchedulerExecutorServiceImpl(CeConfiguration ceConfiguration) {
        super((ExecutorService)MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(ceConfiguration.getWorkerMaxCount(), new ThreadFactoryBuilder().setNameFormat("ce-worker-%d").setPriority(1).build())));
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return ((ListeningScheduledExecutorService)this.delegate).submit(task);
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return ((ListeningScheduledExecutorService)this.delegate).submit(task, result);
    }

    public ListenableFuture<?> submit(Runnable task) {
        return ((ListeningScheduledExecutorService)this.delegate).submit(task);
    }

    public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return ((ListeningScheduledExecutorService)this.delegate).schedule(command, delay, unit);
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return ((ListeningScheduledExecutorService)this.delegate).schedule(callable, delay, unit);
    }

    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ((ListeningScheduledExecutorService)this.delegate).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ((ListeningScheduledExecutorService)this.delegate).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

