/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.configuration.CeConfiguration;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerController;

public class CeWorkerControllerImpl
implements CeWorkerController {
    private final ConcurrentHashMap<CeWorker, Status> workerStatuses = new ConcurrentHashMap();
    private final CeConfiguration ceConfiguration;

    public CeWorkerControllerImpl(CeConfiguration ceConfiguration) {
        this.ceConfiguration = ceConfiguration;
        this.logEnabledWorkerCount();
    }

    private void logEnabledWorkerCount() {
        int workerCount = this.ceConfiguration.getWorkerCount();
        if (workerCount > 1) {
            Loggers.get(CeWorkerController.class).info("Compute Engine will use {} concurrent workers to process tasks", (Object)workerCount);
        }
    }

    @Override
    public Optional<CeWorker> getCeWorkerIn(Thread thread) {
        return this.workerStatuses.keySet().stream().filter(t -> t.isExecutedBy(thread)).findFirst();
    }

    @Override
    public CeWorkerController.ProcessingRecorderHook registerProcessingFor(CeWorker ceWorker) {
        return new ProcessingRecorderHookImpl(ceWorker);
    }

    @Override
    public boolean hasAtLeastOneProcessingWorker() {
        return this.workerStatuses.entrySet().stream().anyMatch(e -> e.getValue() == Status.PROCESSING);
    }

    @Override
    public boolean isEnabled(CeWorker ceWorker) {
        return ceWorker.getOrdinal() < this.ceConfiguration.getWorkerCount();
    }

    private class ProcessingRecorderHookImpl
    implements CeWorkerController.ProcessingRecorderHook {
        private final CeWorker ceWorker;

        private ProcessingRecorderHookImpl(CeWorker ceWorker) {
            this.ceWorker = ceWorker;
            CeWorkerControllerImpl.this.workerStatuses.put(this.ceWorker, Status.PROCESSING);
        }

        @Override
        public void close() {
            CeWorkerControllerImpl.this.workerStatuses.put(this.ceWorker, Status.PAUSED);
        }
    }

    static enum Status {
        PROCESSING,
        PAUSED;

    }
}

