/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public final class ArgsUtil {
    public static RubyArray convertToRubyArray(Ruby runtime2, IRubyObject value2, boolean coerce2) {
        if (value2 == null) {
            return RubyArray.newEmptyArray(runtime2);
        }
        if (coerce2) {
            return ArgsUtil.convertToRubyArrayWithCoerce(runtime2, value2);
        }
        return RubyArray.newArrayLight(runtime2, value2);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby runtime2, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return (RubyArray)value2;
        }
        IRubyObject newValue = TypeConverter.convertToType(value2, runtime2.getArray(), "to_ary", false);
        if (newValue.isNil()) {
            return RubyArray.newArrayLight(runtime2, value2);
        }
        if (!(newValue instanceof RubyArray)) {
            throw runtime2.newTypeError(newValue.getMetaClass() + "#to_ary should return Array");
        }
        return (RubyArray)newValue;
    }

    public static int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject ... args2) {
        if (args2.length >= 1) {
            return TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
        }
        return runtime2.getNil();
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject arg2) {
        if (arg2 == null) {
            return runtime2.getNil();
        }
        return TypeConverter.checkHashType(runtime2, arg2);
    }

    public static IRubyObject[] extractKeywordArgs(final ThreadContext context, RubyHash options2, String ... validKeys) {
        IRubyObject[] ret = new IRubyObject[validKeys.length];
        final HashSet<RubySymbol> validKeySet = new HashSet<RubySymbol>(ret.length);
        for (int i2 = 0; i2 < validKeys.length; ++i2) {
            String key2 = validKeys[i2];
            RubySymbol keySym = context.runtime.newSymbol(key2);
            IRubyObject val = options2.fastARef(keySym);
            ret[i2] = val != null ? val : RubyBasicObject.UNDEF;
            validKeySet.add(keySym);
        }
        options2.visitAll(context, new RubyHash.Visitor(){

            @Override
            public void visit(IRubyObject key2, IRubyObject value2) {
                if (!validKeySet.contains(key2)) {
                    throw context.runtime.newArgumentError("unknown keyword: " + key2);
                }
            }
        }, null);
        return ret;
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject[] args2, String ... validKeys) {
        IRubyObject options2 = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (options2 instanceof RubyHash) {
            return ArgsUtil.extractKeywordArgs(context, (RubyHash)options2, validKeys);
        }
        return null;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, RubyHash opts) {
        return opts.op_aref(context, context.runtime.newSymbol(keyword));
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject arg2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, arg2);
        if (opts == context.nil) {
            return context.nil;
        }
        return ArgsUtil.extractKeywordArg(context, keyword, (RubyHash)opts);
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject ... args2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (opts == context.nil) {
            return context.nil;
        }
        return ArgsUtil.extractKeywordArg(context, keyword, (RubyHash)opts);
    }

    public static IRubyObject extractArg(int index2, IRubyObject _default, IRubyObject ... args2) {
        if (index2 < args2.length) {
            return args2[index2];
        }
        return _default;
    }
}

