/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.jruby.CoreExt;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ClasspathLauncher;
import org.jruby.util.URLUtil;

public class JRubyUtilLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        RubyModule JRubyUtil = runtime2.getOrCreateModule("JRuby").defineModuleUnder("Util");
        JRubyUtil.defineAnnotatedMethods(JRubyUtilLibrary.class);
        JRubyUtil.setConstant("SEPARATOR", runtime2.newString("(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):"));
        JRubyUtil.setConstant("ON_WINDOWS", runtime2.newBoolean(Platform.IS_WINDOWS));
    }

    @JRubyMethod(module=true)
    public static IRubyObject gc(ThreadContext context, IRubyObject recv2) {
        System.gc();
        return context.nil;
    }

    @JRubyMethod(name={"objectspace", "object_space?"}, alias={"objectspace?"}, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyBoolean.newBoolean(runtime2, runtime2.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace=", "object_space="}, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = recv2.getRuntime();
        boolean enabled = arg2.isTrue();
        if (enabled) {
            runtime2.getWarnings().warn("ObjectSpace impacts performance. See http://wiki.jruby.org/PerformanceTuning#dont-enable-objectspace");
        }
        runtime2.setObjectSpaceEnabled(enabled);
        return runtime2.newBoolean(enabled);
    }

    @JRubyMethod(name={"classloader_resources"}, module=true)
    public static IRubyObject getClassLoaderResources(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = recv2.getRuntime();
        String resource2 = arg2.convertToString().toString();
        ArrayList<RubyString> urlStrings = new ArrayList<RubyString>();
        try {
            Enumeration<URL> urls = runtime2.getJRubyClassLoader().getResources(resource2);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String urlString = URLUtil.getPath(url);
                urlStrings.add(runtime2.newString(urlString));
            }
            return RubyArray.newArray(runtime2, urlStrings);
        }
        catch (IOException ignore) {
            return runtime2.newEmptyArray();
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject classpath_launcher(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        String launcher = runtime2.getInstanceConfig().getEnvironment().get("RUBY");
        if (launcher == null) {
            launcher = ClasspathLauncher.jrubyCommand(runtime2);
        }
        return runtime2.newString(launcher);
    }

    @JRubyMethod(name={"extra_gem_paths"}, meta=true)
    public static IRubyObject extra_gem_paths(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        List<String> extraGemPaths = runtime2.getInstanceConfig().getExtraGemPaths();
        IRubyObject[] extra_gem_paths2 = new IRubyObject[extraGemPaths.size()];
        int i2 = 0;
        for (String gemPath : extraGemPaths) {
            extra_gem_paths2[i2++] = runtime2.newString(gemPath);
        }
        return RubyArray.newArrayNoCopy(runtime2, extra_gem_paths2);
    }

    @JRubyMethod(name={"cache_stats"}, module=true)
    public static IRubyObject cache_stats(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        RubyHash stat2 = RubyHash.newHash(runtime2);
        stat2.op_aset(context, runtime2.newSymbol("method_invalidation_count"), runtime2.newFixnum(runtime2.getCaches().getMethodInvalidationCount()));
        stat2.op_aset(context, runtime2.newSymbol("constant_invalidation_count"), runtime2.newFixnum(runtime2.getCaches().getConstantInvalidationCount()));
        return stat2;
    }

    @JRubyMethod(module=true)
    public static RubyArray internal_libraries(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        List<String> builtinLibraries = runtime2.getLoadService().getBuiltinLibraries();
        IRubyObject[] names2 = (IRubyObject[])builtinLibraries.stream().map(name2 -> runtime2.newString((String)name2)).toArray(IRubyObject[]::new);
        return runtime2.newArrayNoCopy(names2);
    }

    @Deprecated
    public static class StringUtils {
        public static IRubyObject unseeded_hash(ThreadContext context, IRubyObject recv2) {
            return CoreExt.String.unseeded_hash(context, recv2);
        }
    }
}

