/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S122")
public class OneStatementPerLineCheck
implements SlangCheck {
    private static final String MESSAGE = "Reformat the code to have only one statement per line.";

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, topLevelTree) -> OneStatementPerLineCheck.checkStatements(ctx, topLevelTree.children()));
        init.register(BlockTree.class, (ctx, blockTree) -> OneStatementPerLineCheck.checkStatements(ctx, blockTree.statementOrExpressions()));
    }

    private static void checkStatements(CheckContext ctx, List<Tree> statementsOrExpressions) {
        statementsOrExpressions.stream().collect(Collectors.groupingBy(OneStatementPerLineCheck::getLine)).forEach((line, statements) -> {
            if (statements.size() > 1) {
                OneStatementPerLineCheck.reportIssue(ctx, statements);
            }
        });
    }

    private static void reportIssue(CheckContext ctx, List<Tree> statements) {
        List<SecondaryLocation> secondaryLocations = statements.stream().skip(2L).map(statement -> new SecondaryLocation((Tree)statement, null)).collect(Collectors.toList());
        ctx.reportIssue((HasTextRange)statements.get(1), MESSAGE, secondaryLocations);
    }

    private static int getLine(Tree statementOrExpression) {
        return statementOrExpression.metaData().textRange().start().line();
    }
}

