/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

class DurationStatistics {
    private static final Logger LOG = Loggers.get(DurationStatistics.class);
    private static final String PROPERTY_KEY = "sonar.slang.duration.statistics";
    private final Map<String, AtomicLong> stats = new ConcurrentHashMap<String, AtomicLong>();
    private final boolean recordStat;

    DurationStatistics(Configuration config) {
        this.recordStat = config.getBoolean(PROPERTY_KEY).orElse(false);
    }

    <C, T> BiConsumer<C, T> time(String id2, BiConsumer<C, T> consumer) {
        if (this.recordStat) {
            return (t, u) -> this.time(id2, () -> consumer.accept(t, u));
        }
        return consumer;
    }

    void time(String id2, Runnable runnable) {
        if (this.recordStat) {
            this.time(id2, () -> {
                runnable.run();
                return null;
            });
        } else {
            runnable.run();
        }
    }

    <T> T time(String id2, Supplier<T> supplier) {
        if (this.recordStat) {
            long startTime = System.nanoTime();
            T result2 = supplier.get();
            this.record(id2, System.nanoTime() - startTime);
            return result2;
        }
        return supplier.get();
    }

    void record(String id2, long elapsedTime) {
        this.stats.computeIfAbsent(id2, key2 -> new AtomicLong(0L)).addAndGet(elapsedTime);
    }

    void log() {
        if (this.recordStat) {
            StringBuilder out = new StringBuilder();
            DecimalFormatSymbols symbols2 = new DecimalFormatSymbols(Locale.ROOT);
            symbols2.setGroupingSeparator('\'');
            DecimalFormat format = new DecimalFormat("#,###", symbols2);
            out.append("Duration Statistics");
            this.stats.entrySet().stream().sorted((a, b2) -> Long.compare(((AtomicLong)b2.getValue()).get(), ((AtomicLong)a.getValue()).get())).forEach(e -> out.append(", ").append((String)e.getKey()).append(" ").append(format.format(((AtomicLong)e.getValue()).get() / 1000000L)).append(" ms"));
            LOG.info(out.toString());
        }
    }
}

