/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin.converter;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.ParseException;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.LiteralTreeImpl;
import org.sonarsource.slang.impl.NativeTreeImpl;
import org.sonarsource.slang.impl.TextPointerImpl;

public class ASTConverterValidation
implements ASTConverter {
    private static final Logger LOG = Loggers.get(ASTConverterValidation.class);
    private static final Pattern PUNCTUATOR_PATTERN = Pattern.compile("[^0-9A-Za-z]++");
    private static final Set<String> ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE = new HashSet<String>(Collections.singleton("implicit"));
    private final ASTConverter wrapped;
    private final Map<String, String> firstErrorOfEachKind = new TreeMap<String, String>();
    private final ValidationMode mode;

    public ASTConverterValidation(ASTConverter wrapped, ValidationMode mode2) {
        this.wrapped = wrapped;
        this.mode = mode2;
    }

    public static ASTConverter wrap(ASTConverter converter, Configuration configuration) {
        String mode2 = configuration.get("sonar.slang.converter.validation").orElse(null);
        if (mode2 == null) {
            return converter;
        }
        if (mode2.equals("throw")) {
            return new ASTConverterValidation(converter, ValidationMode.THROW_EXCEPTION);
        }
        if (mode2.equals("log")) {
            return new ASTConverterValidation(converter, ValidationMode.LOG_ERROR);
        }
        throw new IllegalStateException("Unsupported mode: " + mode2);
    }

    @Override
    public Tree parse(String content) {
        Tree tree = this.wrapped.parse(content);
        this.assertTreeIsValid(tree);
        this.assertTokensMatchSourceCode(tree, content);
        return tree;
    }

    @Override
    public void terminate() {
        List<String> errors = this.errors();
        if (!errors.isEmpty()) {
            LOG.error("AST Converter Validation:\n  [AST ERROR] " + String.join((CharSequence)"\n  [AST ERROR] ", errors));
        }
        this.wrapped.terminate();
    }

    @VisibleForTesting
    ValidationMode mode() {
        return this.mode;
    }

    @VisibleForTesting
    List<String> errors() {
        return this.firstErrorOfEachKind.entrySet().stream().map(entry -> (String)entry.getKey() + (String)entry.getValue()).collect(Collectors.toList());
    }

    private void raiseError(String messageKey, String messageDetails, TextPointer position) {
        if (this.mode == ValidationMode.THROW_EXCEPTION) {
            throw new ParseException(messageKey + messageDetails, position);
        }
        String positionDetails = " (line: " + position.line() + ", column: " + (position.lineOffset() + 1) + ")";
        this.firstErrorOfEachKind.putIfAbsent(messageKey, messageDetails + positionDetails);
    }

    private static String kind(Tree tree) {
        return tree.getClass().getSimpleName();
    }

    private void assertTreeIsValid(Tree tree) {
        this.assertTextRangeIsValid(tree);
        this.assertTreeHasAtLeastOneToken(tree);
        this.assertTokensAndChildTokens(tree);
        for (Tree child : tree.children()) {
            if (child == null) {
                this.raiseError(ASTConverterValidation.kind(tree) + " has a null child", "", tree.textRange().start());
                continue;
            }
            if (child.metaData() == null) {
                this.raiseError(ASTConverterValidation.kind(child) + " metaData is null", "", tree.textRange().start());
                continue;
            }
            this.assertTreeIsValid(child);
        }
    }

    private void assertTextRangeIsValid(Tree tree) {
        boolean startOffsetAfterEndOffset;
        TextPointer start2 = tree.metaData().textRange().start();
        TextPointer end2 = tree.metaData().textRange().end();
        boolean bl = startOffsetAfterEndOffset = !(tree instanceof TopLevelTree) && start2.line() == end2.line() && start2.lineOffset() >= end2.lineOffset();
        if (start2.line() <= 0 || end2.line() <= 0 || start2.line() > end2.line() || start2.lineOffset() < 0 || end2.lineOffset() < 0 || startOffsetAfterEndOffset) {
            this.raiseError(ASTConverterValidation.kind(tree) + " invalid range ", tree.metaData().textRange().toString(), start2);
        }
    }

    private void assertTreeHasAtLeastOneToken(Tree tree) {
        if (!(tree instanceof TopLevelTree) && tree.metaData().tokens().isEmpty()) {
            this.raiseError(ASTConverterValidation.kind(tree) + " has no token", "", tree.textRange().start());
        }
    }

    private void assertTokensMatchSourceCode(Tree tree, String code) {
        CodeFormToken codeFormToken = new CodeFormToken(tree.metaData());
        codeFormToken.assertEqualTo(code);
    }

    private void assertTokensAndChildTokens(Tree tree) {
        this.assertTokensAreInsideRange(tree);
        HashSet<Token> parentTokens = new HashSet<Token>(tree.metaData().tokens());
        HashMap<Token, Tree> childByToken = new HashMap<Token, Tree>();
        for (Tree child : tree.children()) {
            if (child == null || child.metaData() == null || ASTConverterValidation.isAllowedMisplacedTree(child)) continue;
            this.assertChildRangeIsInsideParentRange(tree, child);
            this.assertChildTokens(parentTokens, childByToken, tree, child);
        }
        parentTokens.removeAll(childByToken.keySet());
        this.assertUnexpectedTokenKind(tree, parentTokens);
    }

    private static boolean isAllowedMisplacedTree(Tree tree) {
        List<Token> tokens = tree.metaData().tokens();
        return tokens.size() == 1 && ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE.contains(tokens.get(0).text());
    }

    private void assertUnexpectedTokenKind(Tree tree, Set<Token> tokens) {
        if (tree instanceof NativeTreeImpl || tree instanceof LiteralTreeImpl) {
            return;
        }
        List unexpectedTokens = tree instanceof IdentifierTree ? tokens.stream().filter(token -> token.type() == Token.Type.KEYWORD || token.type() == Token.Type.STRING_LITERAL).collect(Collectors.toList()) : tokens.stream().filter(token -> token.type() != Token.Type.KEYWORD).filter(token -> !PUNCTUATOR_PATTERN.matcher(token.text()).matches()).filter(token -> !ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE.contains(token.text())).collect(Collectors.toList());
        if (!unexpectedTokens.isEmpty()) {
            String tokenList = unexpectedTokens.stream().sorted(Comparator.comparing(token -> token.textRange().start())).map(Token::text).collect(Collectors.joining("', '"));
            this.raiseError("Unexpected tokens in " + ASTConverterValidation.kind(tree), ": '" + tokenList + "'", tree.textRange().start());
        }
    }

    private void assertTokensAreInsideRange(Tree tree) {
        TextRange parentRange = tree.metaData().textRange();
        tree.metaData().tokens().stream().filter(token -> !ALLOWED_MISPLACED_TOKENS_OUTSIDE_PARENT_RANGE.contains(token.text())).filter(token -> !token.textRange().isInside(parentRange)).findFirst().ifPresent(token -> this.raiseError(ASTConverterValidation.kind(tree) + " contains a token outside its range", " range: " + parentRange + " tokenRange: " + token.textRange() + " token: '" + token.text() + "'", token.textRange().start()));
    }

    private void assertChildRangeIsInsideParentRange(Tree parent, Tree child) {
        TextRange parentRange = parent.metaData().textRange();
        TextRange childRange = child.metaData().textRange();
        if (!childRange.isInside(parentRange)) {
            this.raiseError(ASTConverterValidation.kind(parent) + " contains a child " + ASTConverterValidation.kind(child) + " outside its range", ", parentRange: " + parentRange + " childRange: " + childRange, childRange.start());
        }
    }

    private void assertChildTokens(Set<Token> parentTokens, Map<Token, Tree> childByToken, Tree parent, Tree child) {
        for (Token token : child.metaData().tokens()) {
            Tree intersectingChild;
            if (!parentTokens.contains(token)) {
                this.raiseError(ASTConverterValidation.kind(child) + " contains a token missing in its parent " + ASTConverterValidation.kind(parent), ", token: '" + token.text() + "'", token.textRange().start());
            }
            if ((intersectingChild = childByToken.get(token)) != null) {
                this.raiseError(ASTConverterValidation.kind(parent) + " has a token used by both children " + ASTConverterValidation.kind(intersectingChild) + " and " + ASTConverterValidation.kind(child), ", token: '" + token.text() + "'", token.textRange().start());
                continue;
            }
            childByToken.put(token, child);
        }
    }

    private class CodeFormToken {
        private final StringBuilder code = new StringBuilder();
        private final List<Comment> commentsInside;
        private int lastLine = 1;
        private int lastLineOffset = 0;
        private int lastComment = 0;

        private CodeFormToken(TreeMetaData metaData) {
            this.commentsInside = metaData.commentsInside();
            metaData.tokens().forEach(this::add);
            this.addRemainingComments();
        }

        private void add(Token token) {
            while (this.lastComment < this.commentsInside.size() && this.commentsInside.get(this.lastComment).textRange().start().compareTo(token.textRange().start()) < 0) {
                Comment comment = this.commentsInside.get(this.lastComment);
                this.addTextAt(comment.text(), comment.textRange());
                ++this.lastComment;
            }
            this.addTextAt(token.text(), token.textRange());
        }

        private void addRemainingComments() {
            for (int i2 = this.lastComment; i2 < this.commentsInside.size(); ++i2) {
                this.addTextAt(this.commentsInside.get(i2).text(), this.commentsInside.get(i2).textRange());
            }
        }

        private void addTextAt(String text, TextRange textRange) {
            while (this.lastLine < textRange.start().line()) {
                this.code.append("\n");
                ++this.lastLine;
                this.lastLineOffset = 0;
            }
            while (this.lastLineOffset < textRange.start().lineOffset()) {
                this.code.append(' ');
                ++this.lastLineOffset;
            }
            this.code.append(text);
            this.lastLine = textRange.end().line();
            this.lastLineOffset = textRange.end().lineOffset();
        }

        private void assertEqualTo(String expectedCode) {
            String[] actualLines = this.lines(this.code.toString());
            String[] expectedLines = this.lines(expectedCode);
            for (int i2 = 0; i2 < actualLines.length && i2 < expectedLines.length; ++i2) {
                if (actualLines[i2].equals(expectedLines[i2])) continue;
                ASTConverterValidation.this.raiseError("Unexpected AST difference", ":\n      Actual   : " + actualLines[i2] + "\n      Expected : " + expectedLines[i2] + "\n", new TextPointerImpl(i2 + 1, 0));
            }
            if (actualLines.length != expectedLines.length) {
                ASTConverterValidation.this.raiseError("Unexpected AST number of lines", " actual: " + actualLines.length + ", expected: " + expectedLines.length, new TextPointerImpl(Math.min(actualLines.length, expectedLines.length), 0));
            }
        }

        private String[] lines(String code) {
            return code.replace('\t', ' ').replaceFirst("[\r\n ]+$", "").split(" *(\r\n|\n|\r)", -1);
        }
    }

    public static enum ValidationMode {
        THROW_EXCEPTION,
        LOG_ERROR;

    }
}

